/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.irods.DefaultTransferOptionsConfigurer;
import ch.cyberduck.core.irods.DefaultTransferStatusCallbackListener;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.File;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class IRODSDownloadFeature
implements Download {
    private final IRODSSession session;
    private final Preferences preferences = PreferencesFactory.get();

    public IRODSDownloadFeature(IRODSSession session) {
        this.session = session;
    }

    public void download(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback connectionCallback, PasswordCallback passwordCallback) throws BackgroundException {
        try {
            TransferOptions options;
            TransferControlBlock block;
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
            if (f.exists()) {
                block = DefaultTransferControlBlock.instance((String)"", (int)this.preferences.getInteger("connection.retry"));
                options = new DefaultTransferOptionsConfigurer().configure(new TransferOptions());
                if (Host.TransferType.unknown.equals((Object)this.session.getHost().getTransferType())) {
                    options.setUseParallelTransfer(Host.TransferType.valueOf((String)PreferencesFactory.get().getProperty("queue.transfer.type")).equals((Object)Host.TransferType.concurrent));
                } else {
                    options.setUseParallelTransfer(this.session.getHost().getTransferType().equals((Object)Host.TransferType.concurrent));
                }
            } else {
                throw new NotfoundException(file.getAbsolute());
            }
            block.setTransferOptions(options);
            DataTransferOperations transfer = fs.getIRODSAccessObjectFactory().getDataTransferOperations(fs.getIRODSAccount());
            transfer.getOperation(f, new File(local.getAbsolute()), (TransferStatusCallbackListener)new DefaultTransferStatusCallbackListener(status, listener, block), block);
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    public boolean offset(Path file) {
        return false;
    }

    public Download withReader(Read reader) {
        return this;
    }
}

