/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sts;

import ch.cyberduck.core.AsciiRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class STSCredentialsConfigurator {
    private static final Logger log = Logger.getLogger(STSCredentialsConfigurator.class);
    private final PasswordCallback prompt;

    public STSCredentialsConfigurator(PasswordCallback prompt) {
        this.prompt = prompt;
    }

    public Credentials configure(Host host) throws LoginFailureException, LoginCanceledException {
        Map<String, Map<String, String>> allProfileProperties;
        Credentials credentials = new Credentials(host.getCredentials());
        Local file = LocalFactory.get((Local)LocalFactory.get((Local)LocalFactory.get(), (String)".aws"), (String)"credentials");
        final String profile = host.getCredentials().getUsername();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Look for profile name %s in %s", profile, file));
        }
        if (!file.exists()) {
            log.warn((Object)"Missing configuration file ~/.aws/credentials. Skip auto configuration");
            return host.getCredentials();
        }
        try {
            allProfileProperties = new ProfilesConfigFileLoaderHelper().parseProfileProperties(new Scanner(file.getInputStream(), StandardCharsets.UTF_8.name()));
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure reading %s", file), (Throwable)e);
            return credentials;
        }
        LinkedHashMap<String, BasicProfile> profilesByName = new LinkedHashMap<String, BasicProfile>();
        for (Map.Entry<String, Map<String, String>> entry : allProfileProperties.entrySet()) {
            String profileName = entry.getKey();
            Map<String, String> properties = entry.getValue();
            profilesByName.put(profileName, new BasicProfile(profileName, properties));
        }
        Map profiles = new AllProfiles(profilesByName).getProfiles();
        Optional<Map.Entry<String, BasicProfile>> optional = profiles.entrySet().stream().filter(new Predicate<Map.Entry<String, BasicProfile>>(){

            @Override
            public boolean test(Map.Entry<String, BasicProfile> entry) {
                String profileName = entry.getKey();
                BasicProfile basicProfile = entry.getValue();
                String awsAccessIdKey = basicProfile.getAwsAccessIdKey();
                if (StringUtils.equals((CharSequence)profileName, (CharSequence)profile) || StringUtils.equals((CharSequence)awsAccessIdKey, (CharSequence)profile)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Found matching profile %s", profile));
                    }
                    return true;
                }
                return false;
            }
        }).findFirst();
        if (optional.isPresent()) {
            Map.Entry<String, BasicProfile> entry = optional.get();
            BasicProfile basicProfile = entry.getValue();
            if (basicProfile.isRoleBasedProfile()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Configure credentials from role based profile %s", basicProfile.getProfileName()));
                }
                if (StringUtils.isBlank((CharSequence)basicProfile.getRoleSourceProfile())) {
                    throw new LoginFailureException(String.format("Missing source profile reference in profile %s", basicProfile.getProfileName()));
                }
                if (!profiles.containsKey(basicProfile.getRoleSourceProfile())) {
                    throw new LoginFailureException(String.format("Missing source profile with name %s", basicProfile.getRoleSourceProfile()));
                }
                BasicProfile sourceProfile = (BasicProfile)profiles.get(basicProfile.getRoleSourceProfile());
                AWSSecurityTokenService service = this.getTokenService(ProxyFactory.get().find(host), host.getRegion(), sourceProfile.getAwsAccessIdKey(), sourceProfile.getAwsSecretAccessKey(), sourceProfile.getAwsSessionToken());
                String tokenCode = basicProfile.getProperties().containsKey("mfa_serial") ? this.prompt.prompt(host, LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), String.format("%s %s", LocaleFactory.localizedString((String)"Multi-Factor Authentication", (String)"S3"), basicProfile.getProperties().get("mfa_serial")), new LoginOptions(host.getProtocol()).password(true).passwordPlaceholder(LocaleFactory.localizedString((String)"MFA Authentication Code", (String)"S3")).keychain(false)).getPassword() : null;
                AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(basicProfile.getRoleArn()).withSerialNumber((String)basicProfile.getProperties().getOrDefault("mfa_serial", null)).withTokenCode(tokenCode).withRoleSessionName(new AsciiRandomStringService().random());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Request %s from %s", assumeRoleRequest, service));
                }
                try {
                    AssumeRoleResult assumeRoleResult = service.assumeRole(assumeRoleRequest);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Set credentials from %s", assumeRoleResult));
                    }
                    credentials.setUsername(assumeRoleResult.getCredentials().getAccessKeyId());
                    credentials.setPassword(assumeRoleResult.getCredentials().getSecretAccessKey());
                    credentials.setToken(assumeRoleResult.getCredentials().getSessionToken());
                }
                catch (AWSSecurityTokenServiceException e) {
                    throw new LoginFailureException(e.getErrorMessage(), (Throwable)e);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Configure credentials from basic profile %s", basicProfile.getProfileName()));
                }
                if (StringUtils.isNotBlank((CharSequence)basicProfile.getAwsSessionToken())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Set session token credentials from profile %s", profile));
                    }
                    credentials.setUsername(basicProfile.getAwsAccessIdKey());
                    credentials.setPassword(basicProfile.getAwsSecretAccessKey());
                    credentials.setToken(basicProfile.getAwsSessionToken());
                } else if (host.getProtocol().isTokenConfigurable()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Get session token from credentials in profile %s", basicProfile.getProfileName()));
                    }
                    AWSSecurityTokenService service = this.getTokenService(ProxyFactory.get().find(host), host.getRegion(), basicProfile.getAwsAccessIdKey(), basicProfile.getAwsSecretAccessKey(), basicProfile.getAwsSessionToken());
                    GetSessionTokenRequest sessionTokenRequest = new GetSessionTokenRequest();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request %s from %s", sessionTokenRequest, service));
                    }
                    try {
                        GetSessionTokenResult sessionTokenResult = service.getSessionToken(sessionTokenRequest);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Set credentials from %s", sessionTokenResult));
                        }
                        credentials.setUsername(sessionTokenResult.getCredentials().getAccessKeyId());
                        credentials.setPassword(sessionTokenResult.getCredentials().getSecretAccessKey());
                        credentials.setToken(sessionTokenResult.getCredentials().getSessionToken());
                    }
                    catch (AWSSecurityTokenServiceException e) {
                        throw new LoginFailureException(e.getErrorMessage(), (Throwable)e);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Set static credentials from profile %s", basicProfile.getProfileName()));
                    }
                    credentials.setUsername(basicProfile.getAwsAccessIdKey());
                    credentials.setPassword(basicProfile.getAwsSecretAccessKey());
                }
            }
        }
        return credentials;
    }

    protected AWSSecurityTokenService getTokenService(Proxy proxy, String region, final String accessKey, final String secretKey, final String sessionToken) {
        ClientConfiguration configuration = new ClientConfiguration();
        int timeout = PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
        configuration.setConnectionTimeout(timeout);
        configuration.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        configuration.setUserAgentPrefix(ua.get());
        configuration.setMaxErrorRetry(0);
        configuration.setMaxConnections(1);
        configuration.setUseGzip(PreferencesFactory.get().getBoolean("http.compression.enable"));
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                configuration.setProxyHost(proxy.getHostname());
                configuration.setProxyPort(proxy.getPort());
            }
        }
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)(StringUtils.isBlank((CharSequence)sessionToken) ? new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return accessKey;
            }

            public String getAWSSecretKey() {
                return secretKey;
            }
        } : new AWSSessionCredentials(){

            public String getAWSAccessKeyId() {
                return accessKey;
            }

            public String getAWSSecretKey() {
                return secretKey;
            }

            public String getSessionToken() {
                return sessionToken;
            }
        })))).withClientConfiguration(configuration)).withRegion(StringUtils.isNotBlank((CharSequence)region) ? Regions.fromName((String)region) : Regions.DEFAULT_REGION)).build();
    }

    private static final class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        protected void onEmptyOrCommentLine(String profileName, String line) {
        }

        protected void onProfileStartingLine(String newProfileName, String line) {
            this.allProfileProperties.put(newProfileName, new HashMap());
        }

        protected void onProfileEndingLine(String prevProfileName) {
        }

        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            Map<String, String> properties = this.allProfileProperties.get(profileName);
            if (properties.containsKey(propertyKey)) {
                throw new IllegalArgumentException("Duplicate property values for [" + propertyKey + "].");
            }
            properties.put(propertyKey, propertyValue);
        }

        protected void onEndOfFile() {
        }
    }
}

