/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.CryptoExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.CryptoOutputStream;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.InvalidFileKeyException;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CryptoWriteFeature
implements Write<VersionId> {
    private static final Logger log = Logger.getLogger(CryptoWriteFeature.class);
    private final SDSSession session;
    private final Write<VersionId> proxy;

    public CryptoWriteFeature(SDSSession session, Write<VersionId> proxy) {
        this.session = session;
        this.proxy = proxy;
    }

    public StatusOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Read file key for file %s", file));
            }
            FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
            return new CryptoOutputStream(this.session, this.proxy.write(file, status, callback), Crypto.createFileEncryptionCipher((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey)), status);
        }
        catch (CryptoSystemException | InvalidFileKeyException e) {
            throw new CryptoExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.proxy.append(file, length, cache);
    }

    public boolean temporary() {
        return this.proxy.temporary();
    }

    public boolean random() {
        return this.proxy.random();
    }
}

