/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.MoveNodesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFileRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFolderRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateRoomRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class SDSMoveFeature
implements Move {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSMoveFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            if (status.isExists()) {
                new SDSDeleteFeature(this.session, this.nodeid).delete(Collections.singletonList(renamed), (PasswordCallback)connectionCallback, callback);
            }
            long nodeId = Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            if (!new SimplePathPredicate(file.getParent()).test(renamed.getParent())) {
                new NodesApi((ApiClient)this.session.getClient()).moveNodes(Long.parseLong(this.nodeid.getFileid(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())), new MoveNodesRequest().resolutionStrategy(MoveNodesRequest.ResolutionStrategyEnum.AUTORENAME).addNodeIdsItem(nodeId), "", null);
            }
            if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
                if (this.containerService.isContainer(file)) {
                    return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(new NodesApi((ApiClient)this.session.getClient()).updateRoom(nodeId, new UpdateRoomRequest().name(renamed.getName()), "", null)));
                }
                if (file.isDirectory()) {
                    return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(new NodesApi((ApiClient)this.session.getClient()).updateFolder(nodeId, new UpdateFolderRequest().name(renamed.getName()), "", null)));
                }
                return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(new NodesApi((ApiClient)this.session.getClient()).updateFile(nodeId, new UpdateFileRequest().name(renamed.getName()), "", null)));
            }
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(renamed.attributes()).withVersionId(file.attributes().getVersionId()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source) && !new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            return false;
        }
        if (target.getParent().isRoot() && !source.getParent().isRoot()) {
            return false;
        }
        SDSPermissionsFeature acl = new SDSPermissionsFeature(this.session, this.nodeid);
        return acl.containsRole(source, SDSPermissionsFeature.CHANGE_ROLE) && acl.containsRole(source, SDSPermissionsFeature.DELETE_ROLE) && acl.containsRole(target, SDSPermissionsFeature.CREATE_ROLE);
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

