/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2AuthorizedUrlProvider;
import ch.cyberduck.core.b2.B2BucketTypeFeature;
import ch.cyberduck.core.b2.B2DeleteFeature;
import ch.cyberduck.core.b2.B2DirectoryFeature;
import ch.cyberduck.core.b2.B2ErrorResponseInterceptor;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2FindFeature;
import ch.cyberduck.core.b2.B2HomeFinderService;
import ch.cyberduck.core.b2.B2LargeUploadWriteFeature;
import ch.cyberduck.core.b2.B2LifecycleFeature;
import ch.cyberduck.core.b2.B2ListService;
import ch.cyberduck.core.b2.B2MetadataFeature;
import ch.cyberduck.core.b2.B2ReadFeature;
import ch.cyberduck.core.b2.B2SearchFeature;
import ch.cyberduck.core.b2.B2ThresholdUploadService;
import ch.cyberduck.core.b2.B2TimestampFeature;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.b2.B2UrlProvider;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2Session
extends HttpSession<B2ApiClient> {
    private B2ErrorResponseInterceptor retryHandler;
    private final B2FileidProvider fileid = new B2FileidProvider(this);

    public B2Session(Host host) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
    }

    public B2Session(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public B2ApiClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.retryHandler = new B2ErrorResponseInterceptor(this);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.retryHandler);
        return new B2ApiClient(configuration.build());
    }

    public void logout() throws BackgroundException {
        try {
            ((B2ApiClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            String accountId = this.host.getCredentials().getUsername();
            String applicationKey = this.host.getCredentials().getPassword();
            this.retryHandler.setTokens(accountId, applicationKey, ((B2ApiClient)this.client).authenticate(accountId, applicationKey).getAuthorizationToken());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new B2ListService(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)new B2TouchFeature(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new B2ReadFeature(this, this.fileid);
        }
        if (type == Upload.class) {
            return (T)new B2ThresholdUploadService(this, this.fileid);
        }
        if (type == MultipartWrite.class) {
            return (T)new B2LargeUploadWriteFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)((Object)new B2WriteFeature(this, this.fileid));
        }
        if (type == Directory.class) {
            return (T)new B2DirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new B2DeleteFeature(this, this.fileid);
        }
        if (type == UrlProvider.class) {
            return (T)new B2UrlProvider(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new B2AuthorizedUrlProvider(this, this.fileid);
        }
        if (type == Find.class) {
            return (T)new B2FindFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new B2AttributesFinderFeature(this, this.fileid);
        }
        if (type == Home.class) {
            return (T)((Object)new B2HomeFinderService(this));
        }
        if (type == AclPermission.class) {
            return (T)((Object)new B2BucketTypeFeature(this, this.fileid));
        }
        if (type == Location.class) {
            return (T)((Object)new B2BucketTypeFeature(this, this.fileid));
        }
        if (type == IdProvider.class) {
            return (T)this.fileid;
        }
        if (type == Lifecycle.class) {
            return (T)new B2LifecycleFeature(this, this.fileid);
        }
        if (type == Search.class) {
            return (T)new B2SearchFeature(this, this.fileid);
        }
        if (type == Headers.class) {
            return (T)new B2MetadataFeature(this, this.fileid);
        }
        if (type == Metadata.class) {
            return (T)new B2MetadataFeature(this, this.fileid);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new B2TimestampFeature(this, this.fileid));
        }
        return (T)super._getFeature(type);
    }
}

