/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public abstract class AbstractDriveListService
implements ListService {
    private static final Logger log = Logger.getLogger(AbstractDriveListService.class);

    protected final AttributedList<Path> iterate(Iterator<OneDriveDrive.Metadata> iterator, Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        while (iterator.hasNext()) {
            OneDriveDrive.Metadata metadata;
            try {
                metadata = iterator.next();
            }
            catch (OneDriveRuntimeException e) {
                log.warn((Object)e.getMessage());
                continue;
            }
            PathAttributes attributes = new PathAttributes();
            attributes.setVersionId(metadata.getId());
            attributes.setSize(metadata.getTotal().longValue());
            String name = metadata.getName();
            if (StringUtils.isBlank((CharSequence)metadata.getName())) {
                name = metadata.getId();
            }
            children.add((Referenceable)new Path(directory, name, EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
            listener.chunk(directory, children);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

