/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutGroupGroupMemberSpectraS3Response;
import com.spectralogic.ds3client.models.GroupMember;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutGroupGroupMemberSpectraS3ResponseParser
extends AbstractResponseParser<PutGroupGroupMemberSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutGroupGroupMemberSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        GroupMember result = XmlOutput.fromXml(inputStream, GroupMember.class);
                        PutGroupGroupMemberSpectraS3Response putGroupGroupMemberSpectraS3Response = new PutGroupGroupMemberSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putGroupGroupMemberSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

