/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.GetBucketSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetBucketSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.GetDataPolicySpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetDataPolicySpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.ModifyDataPolicySpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.UndeleteObjectSpectraS3Request;
import com.spectralogic.ds3client.models.VersioningLevel;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraVersioningFeature
implements Versioning {
    private static final Logger log = Logger.getLogger(SpectraVersioningFeature.class);
    public static final String KEY_REVERTABLE = "revertable";
    private final SpectraSession session;
    private final PathContainerService containerService = new S3PathContainerService();
    private LRUCache<Path, VersioningConfiguration> cache = LRUCache.build((long)10L);

    public SpectraVersioningFeature(SpectraSession session) {
        this.session = session;
    }

    public Versioning withCache(LRUCache<Path, VersioningConfiguration> cache) {
        this.cache = cache;
        return this;
    }

    public VersioningConfiguration getConfiguration(Path file) throws BackgroundException {
        Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return VersioningConfiguration.empty();
        }
        if (this.cache.contains((Object)container)) {
            return (VersioningConfiguration)this.cache.get((Object)container);
        }
        try {
            GetBucketSpectraS3Response bucket = client.getBucketSpectraS3(new GetBucketSpectraS3Request(container.getName()));
            GetDataPolicySpectraS3Response policy = client.getDataPolicySpectraS3(new GetDataPolicySpectraS3Request(bucket.getBucketResult().getDataPolicyId()));
            VersioningConfiguration configuration = new VersioningConfiguration(policy.getDataPolicyResult().getVersioning() == VersioningLevel.KEEP_MULTIPLE_VERSIONS, false);
            this.cache.put((Object)container, (Object)configuration);
            return configuration;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void setConfiguration(Path file, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            VersioningConfiguration current = this.getConfiguration(container);
            if (configuration.isEnabled()) {
                if (current.isEnabled()) {
                    log.debug((Object)String.format("Versioning already enabled for bucket %s", container));
                } else {
                    log.debug((Object)String.format("Enable bucket versioning for %s", container));
                    Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
                    GetBucketSpectraS3Response bucket = client.getBucketSpectraS3(new GetBucketSpectraS3Request(container.getName()));
                    UUID id = bucket.getBucketResult().getDataPolicyId();
                    client.modifyDataPolicySpectraS3(new ModifyDataPolicySpectraS3Request(id).withVersioning(VersioningLevel.KEEP_MULTIPLE_VERSIONS));
                }
            } else {
                log.warn((Object)String.format("Disable bucket versioning for %s is not supported", container));
            }
            this.cache.remove((Object)container);
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isRevertable(Path file) {
        return file.attributes().getCustom().containsKey(KEY_REVERTABLE);
    }

    public void revert(Path file) throws BackgroundException {
        Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
        Path container = this.containerService.getContainer(file);
        try {
            client.undeleteObjectSpectraS3(new UndeleteObjectSpectraS3Request(container.getName(), this.containerService.getKey(file)));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot revert file", (Throwable)e, file);
        }
    }

    public Credentials getToken(String mfaSerial, PasswordCallback callback) {
        return null;
    }
}

