/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.joyent.manta.http.MantaHttpRequestExecutor;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

class InstrumentedMantaHttpRequestExecutor
extends MantaHttpRequestExecutor {
    private final MetricRegistry registry;

    InstrumentedMantaHttpRequestExecutor(MetricRegistry registry) {
        this.registry = registry;
    }

    InstrumentedMantaHttpRequestExecutor(MetricRegistry registry, int waitForContinue) {
        super(waitForContinue);
        this.registry = registry;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        Timer.Context timerContext = this.timer(request).time();
        try {
            HttpResponse httpResponse = super.execute(request, conn, context);
            return httpResponse;
        }
        catch (IOException | HttpException e) {
            this.meter((Exception)e).mark();
            throw e;
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        return this.registry.timer("requests-" + request.getRequestLine().getMethod().toLowerCase());
    }

    private Meter meter(Exception e) {
        Throwable rootEx = (Throwable)ObjectUtils.firstNonNull((Object[])new Throwable[]{ExceptionUtils.getRootCause((Throwable)e), e});
        return this.registry.meter("exceptions-" + rootEx.getClass().getSimpleName());
    }
}

