/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.crypto.AesCtrCipherDetails;
import com.joyent.manta.client.crypto.EncryptingEntityHelper;
import com.joyent.manta.client.crypto.EncryptingPartEntity;
import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.multipart.AbstractMultipartManager;
import com.joyent.manta.client.multipart.EncryptedMultipartUpload;
import com.joyent.manta.client.multipart.EncryptionState;
import com.joyent.manta.client.multipart.EncryptionStateRecorder;
import com.joyent.manta.client.multipart.EncryptionStateSnapshot;
import com.joyent.manta.client.multipart.MantaMultipartStatus;
import com.joyent.manta.client.multipart.MantaMultipartUpload;
import com.joyent.manta.client.multipart.MantaMultipartUploadPart;
import com.joyent.manta.client.multipart.MantaMultipartUploadTuple;
import com.joyent.manta.client.multipart.MultipartOutputStream;
import com.joyent.manta.exception.MantaMultipartException;
import com.joyent.manta.http.EncryptionHttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedMultipartManager<WRAPPED_MANAGER extends AbstractMultipartManager<WRAPPED_UPLOAD, ? extends MantaMultipartUploadPart>, WRAPPED_UPLOAD extends MantaMultipartUpload>
extends AbstractMultipartManager<EncryptedMultipartUpload<WRAPPED_UPLOAD>, MantaMultipartUploadPart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedMultipartManager.class);
    private final SecretKey secretKey;
    private final SupportedCipherDetails cipherDetails;
    private final EncryptionHttpHelper httpHelper;
    private final WRAPPED_MANAGER wrapped;

    public EncryptedMultipartManager(MantaClient mantaClient, WRAPPED_MANAGER wrapped) {
        Validate.notNull((Object)mantaClient, (String)"Manta client must not be null", (Object[])new Object[0]);
        Validate.notNull(wrapped, (String)"Wrapped manager must not be null", (Object[])new Object[0]);
        this.httpHelper = EncryptedMultipartManager.readFieldFromMantaClient("httpHelper", mantaClient, EncryptionHttpHelper.class);
        this.wrapped = wrapped;
        this.secretKey = this.httpHelper.getSecretKey();
        this.cipherDetails = this.httpHelper.getCipherDetails();
        if (!(this.cipherDetails instanceof AesCtrCipherDetails)) {
            throw new UnsupportedOperationException("Currently only AES/CTR cipher/modes are supported for encrypted multipart uploads");
        }
    }

    EncryptedMultipartManager(SecretKey secretKey, SupportedCipherDetails cipherDetails, EncryptionHttpHelper httpHelper, WRAPPED_MANAGER wrapped) {
        this.secretKey = secretKey;
        this.cipherDetails = cipherDetails;
        this.wrapped = wrapped;
        this.httpHelper = httpHelper;
        if (!(this.cipherDetails instanceof AesCtrCipherDetails)) {
            throw new UnsupportedOperationException("Currently only AES/CTR cipher/modes are supported for encrypted multipart uploads");
        }
        assert (this.getMinimumPartSize() == 1 || this.getMinimumPartSize() % cipherDetails.getBlockSizeInBytes() == 0);
    }

    @Override
    public int getMaxParts() {
        return this.wrapped.getMaxParts() - 1;
    }

    @Override
    public int getMinimumPartSize() {
        return this.wrapped.getMinimumPartSize();
    }

    @Override
    public EncryptedMultipartUpload<WRAPPED_UPLOAD> initiateUpload(String path) throws IOException {
        return this.initiateUpload(path, new MantaMetadata());
    }

    @Override
    public EncryptedMultipartUpload<WRAPPED_UPLOAD> initiateUpload(String path, MantaMetadata mantaMetadata) throws IOException {
        return this.initiateUpload(path, mantaMetadata, new MantaHttpHeaders());
    }

    @Override
    public EncryptedMultipartUpload<WRAPPED_UPLOAD> initiateUpload(String path, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        return this.initiateUpload(path, null, mantaMetadata, httpHeaders);
    }

    @Override
    public EncryptedMultipartUpload<WRAPPED_UPLOAD> initiateUpload(String path, Long contentLength, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        Validate.notBlank((CharSequence)path, (String)"Path to object must not be blank", (Object[])new Object[0]);
        MantaMetadata metadata = mantaMetadata == null ? new MantaMetadata() : mantaMetadata;
        MantaHttpHeaders headers = httpHeaders == null ? new MantaHttpHeaders() : httpHeaders;
        EncryptionContext encryptionContext = this.buildEncryptionContext();
        Cipher cipher = encryptionContext.getCipher();
        this.httpHelper.attachEncryptionCipherHeaders(metadata);
        this.httpHelper.attachEncryptedMetadata(metadata);
        this.httpHelper.attachEncryptedEntityHeaders(metadata, cipher);
        metadata.removeAllEncrypted();
        if (headers.getContentLength() != null && headers.getContentLength() > -1L) {
            metadata.put("m-encrypt-plaintext-content-length", headers.getContentLength().toString());
            headers.remove("Content-Length");
        } else if (contentLength != null && contentLength > -1L) {
            metadata.put("m-encrypt-plaintext-content-length", contentLength.toString());
        }
        if (headers.getContentMD5() != null) {
            headers.remove("Content-MD5");
        }
        Object upload = this.wrapped.initiateUpload(path, metadata, headers);
        EncryptionState encryptionState = new EncryptionState(encryptionContext);
        EncryptedMultipartUpload encryptedUpload = new EncryptedMultipartUpload(upload, encryptionState);
        LOGGER.debug("Created new encrypted multipart upload: {}", upload);
        return encryptedUpload;
    }

    @Override
    public Stream<MantaMultipartUpload> listInProgress() throws IOException {
        return this.wrapped.listInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MantaMultipartUploadPart uploadPart(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload, final int partNumber, HttpEntity sourceEntity, HttpContext context) throws IOException {
        Validate.notNull(upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        if (!upload.canUpload()) {
            String msg = "Multipart object is not in a state that it can be used for uploading parts. For encrypted multipart uploads, only multipart upload objects returned from the initiateUpload() method can be used to upload parts.";
            throw new IllegalArgumentException(msg);
        }
        final EncryptionState encryptionState = upload.getEncryptionState();
        EncryptionContext encryptionContext = encryptionState.getEncryptionContext();
        HttpContext ctx = this.buildRequestContext(context);
        encryptionState.getLock().lock();
        try {
            this.validatePartNumber(partNumber);
            if (encryptionState.getLastPartNumber() == -1) {
                encryptionState.setMultipartStream(new MultipartOutputStream(encryptionContext.getCipherDetails().getBlockSizeInBytes()));
                encryptionState.setCipherStream(EncryptingEntityHelper.makeCipherOutputForStream(encryptionState.getMultipartStream(), encryptionContext));
            } else if (encryptionState.getLastPartNumber() + 1 != partNumber) {
                String message = String.format("Encrypted MPU parts must be serial and sequential, expected: %d, got %d", encryptionState.getLastPartNumber() + 1, partNumber);
                throw new MantaMultipartException(new IllegalStateException(message));
            }
            EncryptingPartEntity entity = new EncryptingPartEntity(encryptionState.getCipherStream(), encryptionState.getMultipartStream(), sourceEntity, new EncryptingPartEntity.LastPartCallback(){

                @Override
                public ByteArrayOutputStream call(long uploadedBytes) throws IOException {
                    if (uploadedBytes < (long)EncryptedMultipartManager.this.wrapped.getMinimumPartSize()) {
                        LOGGER.debug("Detected part {} as last part based on size", (Object)partNumber);
                        return encryptionState.remainderAndLastPartAuth();
                    }
                    return new ByteArrayOutputStream();
                }
            });
            MantaMultipartUploadPart mantaMultipartUploadPart = this.uploadPartWithSnapshot(upload, partNumber, ctx, encryptionState, entity, null);
            return mantaMultipartUploadPart;
        }
        finally {
            encryptionState.getLock().unlock();
        }
    }

    @Override
    public void complete(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload, Iterable<? extends MantaMultipartUploadTuple> parts) throws IOException {
        try (Stream<? extends MantaMultipartUploadTuple> stream = StreamSupport.stream(parts.spliterator(), false);){
            this.complete(upload, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload, Stream<? extends MantaMultipartUploadTuple> partsStream) throws IOException {
        EncryptionState encryptionState = upload.getEncryptionState();
        encryptionState.getLock().lock();
        try {
            ByteArrayOutputStream remainderStream;
            Stream<? extends MantaMultipartUploadTuple> finalPartsStream = partsStream;
            EncryptionStateSnapshot snapshot = EncryptionStateRecorder.record(encryptionState, upload.getId());
            if (!encryptionState.isLastPartAuthWritten() && (remainderStream = encryptionState.remainderAndLastPartAuth()).size() > 0) {
                MantaMultipartUploadPart finalPart = this.uploadPartWithSnapshot(upload, encryptionState.getLastPartNumber() + 1, this.buildRequestContext(null), encryptionState, (HttpEntity)new ByteArrayEntity(remainderStream.toByteArray()), snapshot);
                finalPartsStream = Stream.concat(partsStream, Stream.of(finalPart));
            }
            this.wrapped.complete(upload.getWrapped(), finalPartsStream);
        }
        finally {
            encryptionState.getLock().unlock();
        }
    }

    @Override
    public MantaMultipartUploadPart getPart(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload, int partNumber) throws IOException {
        return this.wrapped.getPart(upload.getWrapped(), partNumber);
    }

    @Override
    public MantaMultipartStatus getStatus(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload) throws IOException {
        return this.wrapped.getStatus(upload.getWrapped());
    }

    @Override
    public Stream<MantaMultipartUploadPart> listParts(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload) throws IOException {
        return this.wrapped.listParts(upload.getWrapped());
    }

    @Override
    public void validateThatThereAreSequentialPartNumbers(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload) throws IOException, MantaMultipartException {
        ((AbstractMultipartManager)this.wrapped).validateThatThereAreSequentialPartNumbers(upload.getWrapped());
    }

    @Override
    public void abort(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload) throws IOException {
        this.wrapped.abort(upload.getWrapped());
    }

    private EncryptionContext buildEncryptionContext() {
        return new EncryptionContext(this.secretKey, this.cipherDetails, true);
    }

    private HttpContext buildRequestContext(HttpContext context) {
        Object ctx = context != null ? context : new BasicHttpContext();
        ctx.setAttribute("manta.retry.disable", (Object)true);
        return ctx;
    }

    private MantaMultipartUploadPart uploadPartWithSnapshot(EncryptedMultipartUpload<WRAPPED_UPLOAD> upload, int partNumber, HttpContext httpContext, EncryptionState encryptionState, HttpEntity entity, EncryptionStateSnapshot suppliedSnapshot) throws IOException {
        EncryptionStateSnapshot snapshot = (EncryptionStateSnapshot)ObjectUtils.firstNonNull((Object[])new EncryptionStateSnapshot[]{suppliedSnapshot, EncryptionStateRecorder.record(encryptionState, upload.getId())});
        try {
            Object part = ((AbstractMultipartManager)this.wrapped).uploadPart(upload.getWrapped(), partNumber, entity, httpContext);
            encryptionState.setLastPartNumber(partNumber);
            return part;
        }
        catch (Exception e) {
            if (encryptionState.getLastPartNumber() != partNumber) {
                EncryptionStateRecorder.rewind(encryptionState, snapshot);
            }
            throw e;
        }
    }

    public WRAPPED_MANAGER getWrapped() {
        return this.wrapped;
    }
}

