/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.multipart.MantaMultipartManager;
import com.joyent.manta.client.multipart.MantaMultipartUpload;
import com.joyent.manta.client.multipart.MantaMultipartUploadPart;
import com.joyent.manta.client.multipart.MantaMultipartUploadTuple;
import com.joyent.manta.exception.MantaMultipartException;
import com.joyent.manta.http.entity.ExposedByteArrayEntity;
import com.joyent.manta.http.entity.ExposedStringEntity;
import com.joyent.manta.http.entity.MantaInputStreamEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.protocol.HttpContext;

abstract class AbstractMultipartManager<UPLOAD extends MantaMultipartUpload, PART extends MantaMultipartUploadPart>
implements MantaMultipartManager<UPLOAD, PART> {
    AbstractMultipartManager() {
    }

    @Override
    public void validateThatThereAreSequentialPartNumbers(UPLOAD upload) throws IOException, MantaMultipartException {
        Validate.notNull(upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        this.listParts(upload).sorted().map(MantaMultipartUploadTuple::getPartNumber).reduce(1, (memo, value) -> {
            if (!memo.equals(value)) {
                MantaMultipartException e = new MantaMultipartException("Missing part of multipart upload");
                e.setContextValue("missing_part", memo);
                e.setContextValue("uploadId", upload.getId());
                e.setContextValue("path", upload.getPath());
                throw e;
            }
            return memo + 1;
        });
    }

    void validatePartNumber(int partNumber) {
        if (partNumber <= 0) {
            throw new IllegalArgumentException("Negative or zero part numbers are not valid");
        }
        if (partNumber > this.getMaxParts()) {
            String msg = String.format("Part number of [%d] exceeds maximum parts (%d)", partNumber, this.getMaxParts());
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public PART uploadPart(UPLOAD upload, int partNumber, String contents) throws IOException {
        this.validatePartNumber(partNumber);
        Validate.notNull((Object)contents, (String)"String must not be null", (Object[])new Object[0]);
        ExposedStringEntity entity = new ExposedStringEntity(contents, ContentType.APPLICATION_OCTET_STREAM);
        return this.uploadPart(upload, partNumber, (HttpEntity)entity, null);
    }

    @Override
    public PART uploadPart(UPLOAD upload, int partNumber, byte[] bytes) throws IOException {
        this.validatePartNumber(partNumber);
        Validate.notNull((Object)bytes, (String)"Byte array must not be null", (Object[])new Object[0]);
        ExposedByteArrayEntity entity = new ExposedByteArrayEntity(bytes, ContentType.APPLICATION_OCTET_STREAM);
        return this.uploadPart(upload, partNumber, (HttpEntity)entity, null);
    }

    @Override
    public PART uploadPart(UPLOAD upload, int partNumber, File file) throws IOException {
        this.validatePartNumber(partNumber);
        Validate.notNull((Object)file, (String)"File must not be null", (Object[])new Object[0]);
        if (!file.exists()) {
            String msg = String.format("File doesn't exist: %s", file.getPath());
            throw new FileNotFoundException(msg);
        }
        if (!file.canRead()) {
            String msg = String.format("Can't access file for read: %s", file.getPath());
            throw new IOException(msg);
        }
        FileEntity entity = new FileEntity(file, ContentType.APPLICATION_OCTET_STREAM);
        return this.uploadPart(upload, partNumber, (HttpEntity)entity, null);
    }

    @Override
    public PART uploadPart(UPLOAD upload, int partNumber, InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream, (String)"InputStream must not be null", (Object[])new Object[0]);
        if (inputStream.getClass().equals(FileInputStream.class)) {
            FileInputStream fin = (FileInputStream)inputStream;
            long contentLength = fin.getChannel().size();
            return this.uploadPart(upload, partNumber, contentLength, inputStream);
        }
        MantaInputStreamEntity entity = new MantaInputStreamEntity(inputStream, ContentType.APPLICATION_OCTET_STREAM);
        return this.uploadPart(upload, partNumber, (HttpEntity)entity, null);
    }

    @Override
    public PART uploadPart(UPLOAD upload, int partNumber, long contentLength, InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream, (String)"InputStream must not be null", (Object[])new Object[0]);
        MantaInputStreamEntity entity = contentLength > -1L ? new MantaInputStreamEntity(inputStream, contentLength, ContentType.APPLICATION_OCTET_STREAM) : new MantaInputStreamEntity(inputStream, ContentType.APPLICATION_OCTET_STREAM);
        return this.uploadPart(upload, partNumber, (HttpEntity)entity, null);
    }

    abstract PART uploadPart(UPLOAD var1, int var2, HttpEntity var3, HttpContext var4) throws IOException;

    protected static <T> T readFieldFromMantaClient(String fieldName, MantaClient mantaClient, Class<T> returnType) {
        Field field = FieldUtils.getField(MantaClient.class, (String)fieldName, (boolean)true);
        try {
            Object object = FieldUtils.readField((Field)field, (Object)mantaClient, (boolean)true);
            return returnType.cast(object);
        }
        catch (IllegalAccessException e) {
            throw new MantaMultipartException("Unable to access httpHelper field on MantaClient");
        }
    }
}

