/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.analytics.QloudstatAnalyticsProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.DistributionUrlProvider;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googlestorage.GoogleStorageLoggingFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.identity.DefaultCredentialsIdentityConfiguration;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.GSWebsiteConfig;
import org.jets3t.service.model.WebsiteConfig;

public class GoogleStorageWebsiteDistributionConfiguration
implements DistributionConfiguration,
Index {
    private final GoogleStorageSession session;
    private final PathContainerService containerService = new S3PathContainerService();

    public GoogleStorageWebsiteDistributionConfiguration(GoogleStorageSession session) {
        this.session = session;
    }

    public List<Distribution.Method> getMethods(Path container) {
        return Collections.singletonList(Distribution.WEBSITE);
    }

    public String getName(Distribution.Method method) {
        return method.toString();
    }

    public String getName() {
        return LocaleFactory.localizedString((String)"Website Configuration", (String)"S3");
    }

    public DescriptiveUrlBag toUrl(Path file) {
        Distribution distribution = new Distribution(URI.create(String.format("%s://%s.%s", Distribution.DOWNLOAD.getScheme(), this.containerService.getContainer(file).getName(), this.getHostname())), Distribution.DOWNLOAD, false);
        distribution.setUrl(URI.create(String.format("%s://%s.%s", Distribution.DOWNLOAD.getScheme(), this.containerService.getContainer(file).getName(), this.getHostname())));
        return new DistributionUrlProvider(distribution).toUrl(file);
    }

    public Distribution read(Path file, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        URI origin = URI.create(String.format("%s://%s.%s", method.getScheme(), container.getName(), this.getHostname()));
        try {
            WebsiteConfig configuration = ((RequestEntityRestStorageService)this.session.getClient()).getWebsiteConfigImpl(container.getName());
            Distribution distribution = new Distribution(origin, method, configuration.isWebsiteConfigActive());
            distribution.setUrl(URI.create(String.format("%s://%s.%s", method.getScheme(), container.getName(), this.getHostname())));
            distribution.setStatus(LocaleFactory.localizedString((String)"Deployed", (String)"S3"));
            distribution.setIndexDocument(configuration.getIndexDocumentSuffix());
            DistributionLogging logging = this.getFeature(DistributionLogging.class, method);
            if (logging != null) {
                LoggingConfiguration c = new GoogleStorageLoggingFeature(this.session).getConfiguration(container);
                distribution.setLogging(c.isEnabled());
                distribution.setLoggingContainer(c.getLoggingTarget());
                distribution.setContainers(new S3BucketListService((S3Session)this.session).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
            }
            return distribution;
        }
        catch (ServiceException e) {
            Distribution distribution = new Distribution(origin, method, false);
            distribution.setStatus(e.getErrorMessage());
            distribution.setUrl(URI.create(String.format("%s://%s.%s", method.getScheme(), container.getName(), this.getHostname())));
            return distribution;
        }
    }

    public void write(Path file, Distribution distribution, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            if (distribution.isEnabled()) {
                String suffix = "index.html";
                if (StringUtils.isNotBlank((CharSequence)distribution.getIndexDocument())) {
                    suffix = PathNormalizer.name((String)distribution.getIndexDocument());
                }
                ((RequestEntityRestStorageService)this.session.getClient()).setWebsiteConfigImpl(container.getName(), (WebsiteConfig)new GSWebsiteConfig(suffix));
                DistributionLogging logging = this.getFeature(DistributionLogging.class, distribution.getMethod());
                if (logging != null) {
                    new GoogleStorageLoggingFeature(this.session).setConfiguration(container, new LoggingConfiguration(distribution.isEnabled(), distribution.getLoggingContainer()));
                }
            } else {
                ((RequestEntityRestStorageService)this.session.getClient()).setWebsiteConfigImpl(container.getName(), (WebsiteConfig)new GSWebsiteConfig());
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot write website configuration", (Throwable)e);
        }
    }

    public <T> T getFeature(Class<T> type, Distribution.Method method) {
        if (type == Index.class) {
            return (T)this;
        }
        if (type == DistributionLogging.class) {
            return (T)((Object)new GoogleStorageLoggingFeature(this.session));
        }
        if (type == AnalyticsProvider.class) {
            return (T)new QloudstatAnalyticsProvider();
        }
        if (type == IdentityConfiguration.class) {
            return (T)new DefaultCredentialsIdentityConfiguration(this.session.getHost());
        }
        return null;
    }

    public String getHostname() {
        return this.session.getHost().getProtocol().getDefaultHostname();
    }
}

