/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.iterate.openstack.swift.method.Authentication10UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication11UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20AccessKeySecretKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20RAXUsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20UsernamePasswordRequest;
import ch.iterate.openstack.swift.method.Authentication20UsernamePasswordTenantIdRequest;
import ch.iterate.openstack.swift.method.Authentication3UsernamePasswordProjectRequest;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftAuthenticationService {
    private static final Logger log = Logger.getLogger(SwiftAuthenticationService.class);

    public Set<? extends AuthenticationRequest> getRequest(Host bookmark, LoginCallback prompt) throws LoginCanceledException {
        StringBuilder url = new StringBuilder();
        url.append(bookmark.getProtocol().getScheme().toString()).append("://");
        url.append(bookmark.getHostname());
        if (bookmark.getProtocol().getScheme().getPort() != bookmark.getPort()) {
            url.append(":").append(bookmark.getPort());
        }
        String context = PathNormalizer.normalize((String)bookmark.getProtocol().getContext());
        url.append(context);
        if (bookmark.getProtocol().getDefaultHostname().endsWith("identity.api.rackspacecloud.com") || bookmark.getHostname().endsWith("identity.api.rackspacecloud.com")) {
            return Collections.singleton(new Authentication20RAXUsernameKeyRequest(URI.create(url.toString()), bookmark.getCredentials().getUsername(), bookmark.getCredentials().getPassword(), null));
        }
        LoginOptions options = new LoginOptions(bookmark.getProtocol()).password(false).anonymous(false).publickey(false);
        if (context.contains("1.0")) {
            return Collections.singleton(new Authentication10UsernameKeyRequest(URI.create(url.toString()), bookmark.getCredentials().getUsername(), bookmark.getCredentials().getPassword()));
        }
        if (context.contains("1.1")) {
            return Collections.singleton(new Authentication11UsernameKeyRequest(URI.create(url.toString()), bookmark.getCredentials().getUsername(), bookmark.getCredentials().getPassword()));
        }
        if (context.contains("2.0")) {
            String user;
            String tenant;
            if (StringUtils.contains((CharSequence)bookmark.getCredentials().getUsername(), (int)58)) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)bookmark.getCredentials().getUsername(), (char)':');
                tenant = parts[0];
                user = parts[1];
            } else {
                user = bookmark.getCredentials().getUsername();
                tenant = prompt.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Tenant Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Tenant Name", (String)"Mosso"))).getUsername();
                bookmark.getCredentials().setUsername(String.format("%s:%s", tenant, bookmark.getCredentials().getUsername()));
            }
            LinkedHashSet<Object> requests = new LinkedHashSet<Object>();
            requests.add(new Authentication20UsernamePasswordRequest(URI.create(url.toString()), user, bookmark.getCredentials().getPassword(), tenant));
            requests.add(new Authentication20UsernamePasswordTenantIdRequest(URI.create(url.toString()), user, bookmark.getCredentials().getPassword(), tenant));
            requests.add(new Authentication20AccessKeySecretKeyRequest(URI.create(url.toString()), user, bookmark.getCredentials().getPassword(), tenant));
            return requests;
        }
        if (context.contains("3")) {
            String user;
            String domain;
            String project;
            if (StringUtils.contains((CharSequence)bookmark.getCredentials().getUsername(), (int)58)) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)bookmark.getCredentials().getUsername(), (char)':');
                if (parts.length == 3) {
                    project = parts[0];
                    domain = parts[1];
                    user = parts[2];
                } else {
                    project = parts[0];
                    user = parts[1];
                    domain = prompt.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"))).getUsername();
                    bookmark.getCredentials().setUsername(String.format("%s:%s:%s", project, domain, bookmark.getCredentials().getUsername()));
                }
            } else {
                user = bookmark.getCredentials().getUsername();
                Credentials projectName = prompt.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Name", (String)"Mosso")));
                if (StringUtils.contains((CharSequence)bookmark.getCredentials().getUsername(), (int)58)) {
                    String[] parts = StringUtils.splitPreserveAllTokens((String)projectName.getUsername(), (char)':');
                    project = parts[0];
                    domain = parts[1];
                } else {
                    project = projectName.getUsername();
                    domain = prompt.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"))).getUsername();
                }
                bookmark.getCredentials().setUsername(String.format("%s:%s:%s", project, domain, bookmark.getCredentials().getUsername()));
            }
            LinkedHashSet<Authentication3UsernamePasswordProjectRequest> requests = new LinkedHashSet<Authentication3UsernamePasswordProjectRequest>();
            requests.add(new Authentication3UsernamePasswordProjectRequest(URI.create(url.toString()), user, bookmark.getCredentials().getPassword(), project, domain));
            return requests;
        }
        log.warn((Object)String.format("Unknown context version in %s. Default to v1 authentication.", context));
        return Collections.singleton(new Authentication10UsernameKeyRequest(URI.create(url.toString()), bookmark.getCredentials().getUsername(), bookmark.getCredentials().getPassword()));
    }
}

