/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Contextual;
import io.milton.context.Factory;
import io.milton.context.Registration;
import io.milton.context.RemovalCallback;
import java.util.HashMap;

public abstract class Context
implements Contextual {
    protected HashMap<Class, Registration> itemByClass = new HashMap();
    protected HashMap<String, Registration> itemByName = new HashMap();

    abstract Registration getOrCreateRegistration(Class var1, Context var2);

    abstract Registration getOrCreateRegistration(String var1, Context var2);

    protected Context() {
    }

    public int numItemsById() {
        return this.itemByName.size();
    }

    @Override
    public <T> T get(String id) {
        Registration<T> reg = this.getRegistration(id);
        return this.get(reg);
    }

    @Override
    public <T> T get(Class<T> c) {
        Registration<T> reg = this.getRegistration(c);
        return this.get(reg);
    }

    private <T> T get(Registration<T> reg) {
        if (reg == null) {
            return null;
        }
        return reg.item;
    }

    public void remove(Class c) {
        Registration reg = this.getRegistration(c);
        if (reg != null) {
            reg.remove();
        }
    }

    public void remove(String key) {
        Registration reg = this.getRegistration(key);
        if (reg != null) {
            reg.remove();
        }
    }

    protected <T> Registration<T> getRegistration(Class<T> c) {
        Registration reg = this.itemByClass.get(c);
        return reg;
    }

    protected <T> Registration<T> getRegistration(String id) {
        Registration o = this.itemByName.get(id);
        return o;
    }

    public <T> Registration<T> put(String id, T o) {
        return this.put(id, o, null);
    }

    public <T> Registration<T> put(T o) {
        return this.put(o, null);
    }

    public <T> Registration<T> put(T o, RemovalCallback f) {
        if (o == null) {
            throw new NullPointerException("o is null");
        }
        Registration<T> reg = new Registration<T>(o, f, this);
        this.register(o.getClass(), o, reg);
        return reg;
    }

    public <T> Registration<T> put(String id, T o, Factory f) {
        Registration<T> reg = new Registration<T>(o, f, this);
        reg.addKey(id);
        this.itemByName.put(id, reg);
        return reg;
    }

    private void register(Class c, Object o, Registration reg) {
        if (c == null) {
            return;
        }
        if (c == Object.class) {
            return;
        }
        this.itemByClass.put(c, reg);
        reg.addKey(c);
        for (Class<?> i : c.getInterfaces()) {
            if (reg.contains(i)) continue;
            this.register(i, o, reg);
        }
        this.register(c.getSuperclass(), o, reg);
    }

    public void tearDown() {
        this.itemByClass = null;
        this.itemByName = null;
    }
}

