/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.Path;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.Dest;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class Utils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Resource findChild(Resource parent, Path path) throws NotAuthorizedException, BadRequestException {
        return Utils._findChild(parent, path.getParts(), 0);
    }

    public static String decodePath(String href) {
        href = href.replace("[", "%5B").replace("]", "%5D");
        href = href.replace(" ", "%20");
        try {
            if (href.startsWith("/")) {
                URI uri = new URI("http://anything.com" + href);
                return uri.getPath();
            }
            URI uri = new URI("http://anything.com/" + href);
            String s = uri.getPath();
            return s.substring(1);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Resource _findChild(Resource parent, String[] arr, int i) throws NotAuthorizedException, BadRequestException {
        if (parent instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)parent;
            String childName = arr[i];
            Resource child = col.child(childName);
            if (child == null) {
                return null;
            }
            if (i < arr.length - 1) {
                return Utils._findChild(child, arr, i + 1);
            }
            return child;
        }
        return null;
    }

    public static Date now() {
        return new Date();
    }

    public static Date addSeconds(Date dt, long seconds) {
        return Utils.addSeconds(dt, (int)seconds);
    }

    public static Date addSeconds(Date dt, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static String getProtocol(String url) {
        String protocol = url.substring(0, url.indexOf(":"));
        return protocol;
    }

    public static String escapeXml(String s) {
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    public static String percentEncode(String s) {
        s = Utils.encodeURL(s, "UTF-8");
        return s;
    }

    public static String encodeURL(String str, String charset) {
        byte[] daten;
        StringBuilder buf = new StringBuilder();
        try {
            daten = charset == null ? str.getBytes() : str.getBytes(charset);
        }
        catch (Exception e) {
            daten = str.getBytes();
        }
        int length = daten.length;
        block5: for (int i = 0; i < length; ++i) {
            char c = (char)(daten[i] & 0xFF);
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case '_': {
                    buf.append(c);
                    continue block5;
                }
                default: {
                    if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                        buf.append(c);
                        continue block5;
                    }
                    buf.append('%');
                    buf.append(hexDigits[c >> 4 & 0xF]);
                    buf.append(hexDigits[c & 0xF]);
                }
            }
        }
        return buf.toString();
    }

    private static String _percentEncode(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        String ns = Utils.normalize(s);
        ByteBuffer bb = null;
        bb = Charset.forName("UTF-8").encode(CharBuffer.wrap(ns));
        StringBuilder sb = new StringBuilder();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (Utils.isUnReserved(b)) {
                sb.append((char)b);
                continue;
            }
            Utils.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    private static boolean isUnReserved(int b) {
        return Utils.inRange(b, 65, 90) || Utils.inRange(b, 97, 122) || Utils.inRange(b, 48, 57) || Utils.inList(b, 45, 46, 95, 126);
    }

    private static boolean inRange(int b, int lower, int upper) {
        return b >= lower && b <= upper;
    }

    private static boolean inList(int b, int ... nums) {
        for (int i : nums) {
            if (b != i) continue;
            return true;
        }
        return false;
    }

    private static boolean isSquareBracket(int b) {
        return b == 91 || b == 93;
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b & 0xF]);
    }

    public static Date mostRecent(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        Date recent = dates[0];
        for (Date dt : dates) {
            if (dt.getTime() <= recent.getTime()) continue;
            recent = dt;
        }
        return recent;
    }

    private static String normalize(String s) {
        return s;
    }

    public static String toCsv(Collection<String> list) {
        return Utils.toCsv(list, true);
    }

    public static String toCsv(Collection<String> list, boolean addSpace) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String res = "";
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            res = res + it.next();
            if (!it.hasNext()) continue;
            if (addSpace) {
                res = res + ", ";
                continue;
            }
            res = res + ",";
        }
        return res;
    }

    public static String stripServer(String href) {
        if (href.startsWith("http")) {
            return href.substring(href.indexOf("/", 8));
        }
        return href;
    }

    public static String truncateFileName(String agent, String s) {
        if (agent == null) {
            return s;
        }
        if (agent.contains("MSIE")) {
            if (s.contains("\\")) {
                int pos = s.lastIndexOf("\\");
                return s.substring(pos + 1);
            }
            return s;
        }
        return s;
    }

    public static long withMax(long n, long max) {
        if (n > max) {
            return max;
        }
        return n;
    }

    public static String suffixSlash(String parentHref) {
        if (parentHref == null) {
            return null;
        }
        if (parentHref.endsWith("/")) {
            return parentHref;
        }
        return parentHref + "/";
    }

    public static Dest getDecodedDestination(String destinationHeader) {
        String sDest = destinationHeader;
        URI destUri = URI.create(sDest);
        sDest = destUri.getPath();
        Dest dest = new Dest(destUri.getHost(), sDest);
        return dest;
    }
}

