/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StringSplitUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringSplitUtils() {
    }

    public static String[] split(String toSplit, String delimiter) {
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter can only be one character in length");
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + 1);
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Map splitEachArrayElementAndCreateMap(String[] array, String delimiter, String removeCharacters) {
        if (array == null || array.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String element : array) {
            String postRemove = removeCharacters == null ? element : StringSplitUtils.replace(element, removeCharacters, "");
            String[] splitThisArrayElement = StringSplitUtils.split(postRemove, delimiter);
            if (splitThisArrayElement == null) continue;
            map.put(splitThisArrayElement[0].trim(), splitThisArrayElement[1].trim());
        }
        return map;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuilder sbuf = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static String substringBeforeLast(String str, String separator) {
        if (str == null || separator == null || str.length() == 0 || separator.length() == 0) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null || separator.length() == 0) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String[] splitIgnoringQuotes(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == '\"') {
                ++i;
                while (i < len) {
                    if (str.charAt(i) == '\"') {
                        ++i;
                        break;
                    }
                    ++i;
                }
                match = true;
                continue;
            }
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

