/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void copy(File source, File dest) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            int i = is.read();
            while (i >= 0) {
                os.write(i);
                i = is.read();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            FileUtils.close(is);
            FileUtils.close(os);
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            {
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    FileUtils.close(os);
                    throw throwable;
                }
            }
            FileUtils.close(is);
            FileUtils.close(os);
        }
        FileUtils.close(is);
        FileUtils.close(os);
    }

    public static ByteArrayOutputStream readIn(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamUtils.readTo(is, (OutputStream)os, true, true);
        return os;
    }

    public static String readResource(Class cl, String res) throws IOException {
        InputStream in = cl.getResourceAsStream(res);
        if (in == null) {
            throw new IOException("Failed to read resource: " + res + " relative to class: " + cl.getCanonicalName());
        }
        ByteArrayOutputStream out = FileUtils.readIn(in);
        return out.toString();
    }

    public static void close(InputStream in) {
        try {
            if (in == null) {
                return;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Closeable in) {
        try {
            if (in == null) {
                return;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Object o) {
        if (o == null) {
            return;
        }
        try {
            Method m = o.getClass().getMethod("close", new Class[0]);
            m.invoke(o, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InputStream openFile(File file) throws FileNotFoundException {
        FileInputStream fin = null;
        BufferedInputStream br = null;
        fin = new FileInputStream(file);
        br = new BufferedInputStream(fin);
        return br;
    }

    public OutputStream openFileForWrite(File file) throws FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        return bout;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readFile(File file) throws FileNotFoundException {
        String string;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            String s = null;
            while ((s = br.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            string = sb.toString();
        }
        catch (FileNotFoundException e) {
            try {
                throw e;
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(br);
                FileUtils.close(fr);
                throw throwable;
            }
        }
        FileUtils.close(br);
        FileUtils.close(fr);
        return string;
    }

    public String read(InputStream in) {
        try {
            int s;
            BufferedInputStream bin = new BufferedInputStream(in);
            byte[] buf = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((s = bin.read(buf)) > -1) {
                sb.append(new String(buf, 0, s));
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File resolveRelativePath(File start, String path) {
        String[] arr = path.split("/");
        File f = start;
        for (String s : arr) {
            f = s.equals("..") ? f.getParentFile() : new File(f, s);
        }
        return f;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(String nm) {
        if (nm == null) {
            return null;
        }
        try {
            int pos = nm.lastIndexOf(".");
            if (pos > -1) {
                String ext = nm.substring(pos + 1);
                return ext;
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(nm, e);
        }
    }

    public static String stripExtension(String nm) {
        if (nm.contains(".")) {
            String[] arr = nm.split("[.]");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length - 1; ++i) {
                if (arr[i] == null) continue;
                if (i != 0) {
                    sb.append(".");
                }
                sb.append(arr[i]);
            }
            return sb.toString();
        }
        return nm;
    }

    public static String preprendExtension(String filename, String newExt) {
        String ext = FileUtils.getExtension(filename);
        filename = FileUtils.stripExtension(filename);
        filename = filename + "." + newExt + "." + ext;
        return filename;
    }

    public static String incrementFileName(String name, boolean isFirst) {
        int count;
        String mainName = FileUtils.stripExtension(name);
        String ext = FileUtils.getExtension(name);
        if (isFirst) {
            count = 1;
        } else {
            int pos = mainName.lastIndexOf("(");
            if (pos > 0) {
                String sNum = mainName.substring(pos + 1, mainName.length() - 1);
                count = Integer.parseInt(sNum) + 1;
                mainName = mainName.substring(0, pos);
            } else {
                count = 1;
            }
        }
        String s = mainName + "(" + count + ")";
        if (ext != null) {
            s = s + "." + ext;
        }
        return s;
    }

    public static String sanitiseName(String s) {
        s = s.replaceAll("[ ]", "_");
        return s;
    }

    public static void readLines(File f, List<String> lines) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            for (Object oLine : IOUtils.readLines((InputStream)in)) {
                lines.add(oLine.toString());
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public static void writeLines(File f, List<String> lines) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(f);
            IOUtils.writeLines(lines, null, (OutputStream)fout);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }
}

