/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.copy;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCopyFilter
implements TransferPathFilter {
    private static final Logger log = Logger.getLogger(AbstractCopyFilter.class);
    protected final Session<?> sourceSession;
    protected final Session<?> destinationSession;
    protected Cache<Path> sourceCache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    protected final Cache<Path> destinationCache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    protected final Map<Path, Path> files;
    private final UploadFilterOptions options;

    public AbstractCopyFilter(Session<?> source, Session<?> destination, Map<Path, Path> files) {
        this(source, destination, files, new UploadFilterOptions());
    }

    public AbstractCopyFilter(Session<?> source, Session<?> destination, Map<Path, Path> files, UploadFilterOptions options) {
        this.sourceSession = source;
        this.destinationSession = destination;
        this.files = files;
        this.options = options;
    }

    @Override
    public TransferPathFilter withCache(Cache<Path> cache) {
        this.sourceCache = cache;
        return this;
    }

    @Override
    public TransferStatus prepare(Path source, Local n, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        AclPermission feature;
        TransferStatus status = new TransferStatus();
        PathAttributes attributes = ((AttributesFinder)this.sourceSession.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(this.sourceSession))).withCache(this.sourceCache).find(source);
        if (source.isFile()) {
            status.setLength(attributes.getSize());
        }
        status.setRemote(attributes);
        if (this.options.permissions) {
            status.setPermission(attributes.getPermission());
        }
        if (this.options.timestamp) {
            status.setTimestamp(attributes.getModificationDate());
        }
        if (this.options.acl && (feature = this.sourceSession.getFeature(AclPermission.class)) != null) {
            try {
                status.setAcl(feature.getPermission(source));
            }
            catch (AccessDeniedException | InteroperabilityException backgroundException) {
                // empty catch block
            }
        }
        status.setChecksum(source.attributes().getChecksum());
        if (parent.isExists()) {
            Path target = this.files.get(source);
            if (((Find)this.destinationSession.getFeature(Find.class, new DefaultFindFeature(this.destinationSession))).withCache(this.destinationCache).find(target)) {
                status.setExists(true);
            }
        }
        return status;
    }

    @Override
    public void apply(Path source, Local n, TransferStatus status, ProgressListener listener) {
    }

    @Override
    public void complete(Path source, Local n, TransferOptions options, TransferStatus status, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Complete %s with status %s", source.getAbsolute(), status));
        }
        if (status.isComplete()) {
            Timestamp timestamp;
            Object feature;
            Path target = this.files.get(source);
            if (!Permission.EMPTY.equals(status.getPermission()) && (feature = this.destinationSession.getFeature(UnixPermission.class)) != null && !Permission.EMPTY.equals(status.getPermission())) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), target.getName(), status.getPermission()));
                    feature.setUnixPermission(target, status.getPermission());
                }
                catch (BackgroundException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            if (!Acl.EMPTY.equals(status.getAcl()) && (feature = this.destinationSession.getFeature(AclPermission.class)) != null) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), target.getName(), status.getAcl()));
                    feature.setPermission(target, status.getAcl());
                }
                catch (BackgroundException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            if (status.getTimestamp() != null && (timestamp = this.destinationSession.getFeature(Timestamp.class)) != null) {
                listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing timestamp of {0} to {1}", "Status"), target.getName(), UserDateFormatterFactory.get().getShortFormat(status.getTimestamp())));
                try {
                    timestamp.setTimestamp(target, status.getTimestamp());
                }
                catch (BackgroundException e) {
                    log.warn((Object)e.getMessage());
                }
            }
        }
    }
}

