/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.aquaticprime.Receipt;
import ch.cyberduck.core.aquaticprime.ReceiptVerifier;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ReceiptFactory
extends LicenseFactory {
    private static final Logger log = Logger.getLogger(ReceiptFactory.class);
    private static final int APPSTORE_VALIDATION_FAILURE = 173;

    public ReceiptFactory() {
        super(LocalFactory.get(PreferencesFactory.get().getProperty("application.receipt.path")), new ReceiptFilter());
    }

    public ReceiptFactory(Local folder) {
        super(folder, new ReceiptFilter());
    }

    @Override
    protected License create() {
        return new LicenseFactory.DefaultLicenseFactory(this).create();
    }

    @Override
    protected License open(Local file) {
        ReceiptVerifier verifier = new ReceiptVerifier(file);
        if (verifier.verify(new DisabledLicenseVerifierCallback())) {
            Receipt receipt = new Receipt(file, verifier.getGuid());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Valid receipt %s in %s", receipt, file));
            }
            Local support = SupportDirectoryFinderFactory.get().find();
            try {
                file.copy(LocalFactory.get(support, String.format("%s.cyberduckreceipt", receipt.getName())));
            }
            catch (AccessDeniedException e) {
                log.warn((Object)e.getMessage());
            }
            return receipt;
        }
        log.error((Object)String.format("Invalid receipt found in %s", file));
        System.exit(173);
        return null;
    }

    @Override
    public List<License> open() throws AccessDeniedException {
        List<License> keys = super.open();
        if (keys.isEmpty()) {
            System.exit(173);
        }
        return keys;
    }

    private static class ReceiptFilter
    implements Filter<Local> {
        private ReceiptFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "receipt".equals(file.getName());
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile("receipt");
        }
    }
}

