/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import org.apache.commons.lang3.StringUtils;

public final class OAuthTokens {
    public static final OAuthTokens EMPTY = new OAuthTokens(null, null, Long.MAX_VALUE);
    private String accessToken;
    private String refreshToken;
    private Long expiryInMilliseconds;

    public OAuthTokens(String accessToken, String refreshToken, Long expiryInMilliseconds) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiryInMilliseconds = expiryInMilliseconds;
    }

    public boolean validate() {
        return StringUtils.isNotEmpty((CharSequence)this.accessToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getExpiryInMilliseconds() {
        return this.expiryInMilliseconds;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expiryInMilliseconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tokens{");
        sb.append("accessToken='").append(this.accessToken).append('\'');
        sb.append(", refreshToken='").append(this.refreshToken).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

