/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.Folder;
import com.dropbox.core.v2.paper.FolderSharingPolicyType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FoldersContainingPaperDoc {
    protected final FolderSharingPolicyType folderSharingPolicyType;
    protected final List<Folder> folders;

    public FoldersContainingPaperDoc(FolderSharingPolicyType folderSharingPolicyType, List<Folder> folders) {
        this.folderSharingPolicyType = folderSharingPolicyType;
        if (folders != null) {
            for (Folder x : folders) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'folders' is null");
            }
        }
        this.folders = folders;
    }

    public FoldersContainingPaperDoc() {
        this(null, null);
    }

    public FolderSharingPolicyType getFolderSharingPolicyType() {
        return this.folderSharingPolicyType;
    }

    public List<Folder> getFolders() {
        return this.folders;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.folderSharingPolicyType, this.folders});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FoldersContainingPaperDoc other = (FoldersContainingPaperDoc)obj;
            return (this.folderSharingPolicyType == other.folderSharingPolicyType || this.folderSharingPolicyType != null && this.folderSharingPolicyType.equals((Object)other.folderSharingPolicyType)) && (this.folders == other.folders || this.folders != null && this.folders.equals(other.folders));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FoldersContainingPaperDoc> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FoldersContainingPaperDoc value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.folderSharingPolicyType != null) {
                g.writeFieldName("folder_sharing_policy_type");
                StoneSerializers.nullable(FolderSharingPolicyType.Serializer.INSTANCE).serialize(value.folderSharingPolicyType, g);
            }
            if (value.folders != null) {
                g.writeFieldName("folders");
                StoneSerializers.nullable(StoneSerializers.list(Folder.Serializer.INSTANCE)).serialize(value.folders, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FoldersContainingPaperDoc deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<Folder> f_folders;
            FolderSharingPolicyType f_folderSharingPolicyType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_folderSharingPolicyType = null;
                f_folders = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("folder_sharing_policy_type".equals(field)) {
                        f_folderSharingPolicyType = StoneSerializers.nullable(FolderSharingPolicyType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("folders".equals(field)) {
                        f_folders = StoneSerializers.nullable(StoneSerializers.list(Folder.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FoldersContainingPaperDoc value = new FoldersContainingPaperDoc(f_folderSharingPolicyType, f_folders);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected FolderSharingPolicyType folderSharingPolicyType = null;
        protected List<Folder> folders = null;

        protected Builder() {
        }

        public Builder withFolderSharingPolicyType(FolderSharingPolicyType folderSharingPolicyType) {
            this.folderSharingPolicyType = folderSharingPolicyType;
            return this;
        }

        public Builder withFolders(List<Folder> folders) {
            if (folders != null) {
                for (Folder x : folders) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'folders' is null");
                }
            }
            this.folders = folders;
            return this;
        }

        public FoldersContainingPaperDoc build() {
            return new FoldersContainingPaperDoc(this.folderSharingPolicyType, this.folders);
        }
    }
}

