/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer.encrypt;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.EncryptionException;
import org.irods.jargon.core.transfer.encrypt.AbstractKeyGenerator;
import org.irods.jargon.core.utils.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESKeyGenerator
extends AbstractKeyGenerator {
    public static final Logger log = LoggerFactory.getLogger(AESKeyGenerator.class);

    public AESKeyGenerator(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) {
        super(pipelineConfiguration, negotiatedClientServerConfiguration);
    }

    @Override
    public SecretKey generateKey() throws EncryptionException {
        log.info("generateKey()");
        return this.initSecretKey();
    }

    private SecretKeySpec initSecretKey() throws EncryptionException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.getPipelineConfiguration().getEncryptionAlgorithmEnum().getKeyGenType());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(256);
            char[] randPwd = new String(kgen.generateKey().getEncoded()).toCharArray();
            PBEKeySpec keySpec = new PBEKeySpec(randPwd, RandomUtils.generateRandomBytesOfLength(this.getPipelineConfiguration().getEncryptionSaltSize()), this.getPipelineConfiguration().getEncryptionNumberHashRounds(), this.getPipelineConfiguration().getEncryptionAlgorithmEnum().getKeySize());
            SecretKey secretKey = factory.generateSecret(keySpec);
            SecretKeySpec secretSpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            return secretSpec;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("error creating secret key", (Throwable)e);
            throw new EncryptionException(e);
        }
    }
}

