/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.transfer.AbstractParallelTransferThread;
import org.irods.jargon.core.transfer.ParallelPutFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelTransferResult;
import org.irods.jargon.core.transfer.encrypt.EncryptionBuffer;
import org.irods.jargon.core.transfer.encrypt.ParallelEncryptionCipherWrapper;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelPutTransferThread
extends AbstractParallelTransferThread
implements Callable<ParallelTransferResult> {
    private final ParallelPutFileTransferStrategy parallelPutFileTransferStrategy;
    private RandomAccessFile localRandomAccessFile = null;
    private ParallelEncryptionCipherWrapper parallelEncryptionCipherWrapper = null;
    public static final Logger log = LoggerFactory.getLogger(ParallelPutTransferThread.class);

    public static ParallelPutTransferThread instance(ParallelPutFileTransferStrategy parallelPutFileTransferStrategy, int threadNumber) throws JargonException {
        return new ParallelPutTransferThread(parallelPutFileTransferStrategy, threadNumber);
    }

    private ParallelPutTransferThread(ParallelPutFileTransferStrategy parallelPutFileTransferStrategy, int threadNumber) throws JargonException {
        super(threadNumber);
        if (parallelPutFileTransferStrategy == null) {
            throw new JargonException("parallelPutFileTransferStrategy is null");
        }
        this.parallelPutFileTransferStrategy = parallelPutFileTransferStrategy;
        try {
            log.info("opening socket to parallel transfer (high) port at port:{}", (Object)parallelPutFileTransferStrategy.getPort());
            Socket s = new Socket();
            if (parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpSendWindowSize() > 0) {
                s.setSendBufferSize(parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpSendWindowSize() * 1024);
            }
            if (parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpReceiveWindowSize() > 0) {
                s.setReceiveBufferSize(parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpReceiveWindowSize() * 1024);
            }
            s.setPerformancePreferences(parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsConnectionTime(), parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsLatency(), parallelPutFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsBandwidth());
            InetSocketAddress address = new InetSocketAddress(parallelPutFileTransferStrategy.getHost(), parallelPutFileTransferStrategy.getPort());
            s.setSoTimeout(parallelPutFileTransferStrategy.getParallelSocketTimeoutInSecs() * 1000);
            s.setKeepAlive(parallelPutFileTransferStrategy.getPipelineConfiguration().isParallelTcpKeepAlive());
            s.setReuseAddress(true);
            s.setTcpNoDelay(false);
            s.connect(address);
            this.setS(s);
            int inputBuffSize = this.parallelPutFileTransferStrategy.getJargonProperties().getInternalInputStreamBufferSize();
            int outputBuffSize = this.parallelPutFileTransferStrategy.getJargonProperties().getInternalOutputStreamBufferSize();
            if (inputBuffSize < 0) {
                this.setIn(this.getS().getInputStream());
            } else if (inputBuffSize == 0) {
                this.setIn(new BufferedInputStream(this.getS().getInputStream()));
            } else {
                this.setIn(new BufferedInputStream(this.getS().getInputStream(), inputBuffSize));
            }
            if (outputBuffSize < 0) {
                this.setOut(this.getS().getOutputStream());
            } else if (outputBuffSize == 0) {
                this.setOut(new BufferedOutputStream(this.getS().getOutputStream()));
            } else {
                this.setOut(new BufferedOutputStream(this.getS().getOutputStream(), outputBuffSize));
            }
            log.info("setting up the encryption if so negotiated");
            if (this.parallelPutFileTransferStrategy.doEncryption()) {
                log.debug("am doing encryption, enable the cypher");
                this.parallelEncryptionCipherWrapper = this.parallelPutFileTransferStrategy.initializeCypherForEncryption();
                log.debug("cypher initialized");
            }
        }
        catch (Exception e) {
            log.error("unable to create transfer thread", (Throwable)e);
            throw new JargonException(e);
        }
    }

    @Override
    public ParallelTransferResult call() throws JargonException {
        try {
            ParallelTransferResult result;
            log.info("getting random access file for local file");
            this.localRandomAccessFile = new RandomAccessFile(this.parallelPutFileTransferStrategy.getLocalFile(), "r");
            log.info("writing the cookie (password) for the output thread");
            byte[] b = new byte[4];
            Host.copyInt(this.parallelPutFileTransferStrategy.getPassword(), b);
            this.getOut().write(b);
            this.getOut().flush();
            log.debug("cookie written for output thread...calling put() to start read/write loop");
            this.put();
            log.debug("put operation completed");
            ParallelTransferResult parallelTransferResult = result = new ParallelTransferResult();
            return parallelTransferResult;
        }
        catch (Throwable e) {
            log.error("An exception occurred during a parallel file put operation", e);
            throw new JargonException("error during parallel file put", e);
        }
        finally {
            log.info("closing sockets, this eats any exceptions");
            this.close();
            log.info("socket conns for parallel transfer closed, now close the file stream");
            try {
                this.localRandomAccessFile.close();
                log.info("streams and files closed");
            }
            catch (IOException iOException) {}
        }
    }

    private void seekToStartingPoint(long offset) throws JargonException {
        try {
            this.localRandomAccessFile.seek(offset);
        }
        catch (IOException e) {
            log.error("IOException in seek", (Throwable)e);
            throw new JargonException(e);
        }
    }

    private void put() throws JargonException {
        log.info("put()..");
        byte[] buffer = null;
        boolean done = false;
        buffer = new byte[this.parallelPutFileTransferStrategy.getJargonProperties().getParallelCopyBufferSize()];
        long currentOffset = 0L;
        try {
            while (!done) {
                if (Thread.interrupted()) {
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                log.debug("in main put() loop, reading header data");
                int operation = this.readInt();
                if (log.isInfoEnabled()) {
                    log.info("   operation:" + operation);
                }
                if (operation != 1) {
                    if (operation == 9999) {
                        log.info("done received");
                        done = true;
                        break;
                    }
                    throw new JargonException("unknown operation received");
                }
                log.debug("put operation");
                int flags = this.readInt();
                if (log.isInfoEnabled()) {
                    log.info("   flags:" + flags);
                }
                long offset = this.readLong();
                if (log.isInfoEnabled()) {
                    log.info("   offset:" + offset);
                }
                if (this.parallelPutFileTransferStrategy.getFileRestartInfo() != null) {
                    this.parallelPutFileTransferStrategy.getRestartManager().updateOffsetForSegment(this.parallelPutFileTransferStrategy.getFileRestartInfo().identifierFromThisInfo(), this.getThreadNumber(), offset);
                }
                long length = this.readLong();
                if (log.isInfoEnabled()) {
                    log.info("   length:" + length);
                }
                if (offset != currentOffset) {
                    this.seekToStartingPoint(offset);
                    currentOffset = offset;
                }
                log.info("buffer length for put is: {}", (Object)buffer.length);
                this.readWriteLoopForCurrentHeaderDirective(buffer, length);
                currentOffset += length;
            }
        }
        catch (Exception e) {
            log.error("An IO exception occurred during a parallel file put operation", (Throwable)e);
            throw new JargonException("IOException during parallel file put", e);
        }
    }

    private void readWriteLoopForCurrentHeaderDirective(byte[] buffer, long length) throws IOException, JargonException {
        int read = 0;
        long totalRead = 0L;
        long transferLength = length;
        long totalWritten = 0L;
        long totalWrittenSinceLastRestartUpdate = 0L;
        log.debug("readWriteLoopForCurrentHeaderDirective()");
        try {
            while (transferLength > 0L) {
                if (Thread.interrupted()) {
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                log.debug("read/write loop at top");
                read = this.localRandomAccessFile.read(buffer, 0, (int)Math.min((long)this.parallelPutFileTransferStrategy.getJargonProperties().getParallelCopyBufferSize(), transferLength));
                log.debug("bytes read: {}", (Object)read);
                if (read <= 0) {
                    log.debug("no read...break out of read/write");
                    break;
                }
                totalRead += (long)read;
                log.debug("getting ready to write to iRODS, new txfr length:{}", (Object)(transferLength -= (long)read));
                if (this.parallelPutFileTransferStrategy.doEncryption()) {
                    log.debug("put with encryption, encrypt this buffer");
                    EncryptionBuffer encryptedBuff = this.parallelEncryptionCipherWrapper.encrypt(Arrays.copyOf(buffer, read));
                    log.debug("iv length:{}", (Object)encryptedBuff.getInitializationVector().length);
                    this.sendInLittleEndian(encryptedBuff.getEncryptedData().length + encryptedBuff.getInitializationVector().length);
                    log.debug("computed length:{}", (Object)(encryptedBuff.getEncryptedData().length + encryptedBuff.getInitializationVector().length));
                    ByteArrayOutputStream buffOut = new ByteArrayOutputStream(encryptedBuff.getEncryptedData().length + encryptedBuff.getInitializationVector().length);
                    buffOut.write(encryptedBuff.getInitializationVector());
                    buffOut.write(encryptedBuff.getEncryptedData());
                    buffOut.writeTo(this.getOut());
                } else {
                    this.getOut().write(buffer, 0, read);
                }
                if (this.parallelPutFileTransferStrategy.getConnectionProgressStatusListener() != null) {
                    this.parallelPutFileTransferStrategy.getConnectionProgressStatusListener().connectionProgressStatusCallback(ConnectionProgressStatus.instanceForSend(read));
                }
                log.debug("wrote data to the buffer");
                totalWritten += (long)read;
                totalWrittenSinceLastRestartUpdate += (long)read;
                if (this.parallelPutFileTransferStrategy.getFileRestartInfo() != null) {
                    log.debug("checking total written for this thread");
                    if (totalWrittenSinceLastRestartUpdate >= 0x100000L) {
                        this.parallelPutFileTransferStrategy.getRestartManager().updateLengthForSegment(this.parallelPutFileTransferStrategy.getFileRestartInfo().identifierFromThisInfo(), this.getThreadNumber(), totalWrittenSinceLastRestartUpdate);
                        totalWrittenSinceLastRestartUpdate = 0L;
                        log.debug("signal storage of new info");
                    }
                }
                Thread.yield();
            }
            log.info("final flush of output buffer");
            this.getOut().flush();
            log.info("for thread, total read: {}", (Object)totalRead);
            log.info("   total written: {}", (Object)totalWritten);
            log.info("   transferLength: {}", (Object)transferLength);
            if (this.parallelPutFileTransferStrategy.getFileRestartInfo() != null) {
                log.debug("checking total written for this thread");
                if (totalWrittenSinceLastRestartUpdate > 0L) {
                    this.parallelPutFileTransferStrategy.getRestartManager().updateLengthForSegment(this.parallelPutFileTransferStrategy.getFileRestartInfo().identifierFromThisInfo(), this.getThreadNumber(), totalWrittenSinceLastRestartUpdate);
                    log.debug("signal storage of new info");
                }
            }
        }
        catch (Throwable e) {
            log.error("error writing to iRODS parallel transfer socket", e);
            JargonException je = new JargonException(e);
            this.setExceptionInTransfer(je);
            throw je;
        }
        if (totalRead != totalWritten) {
            throw new JargonException("totalRead and totalWritten do not agree");
        }
        if (transferLength != 0L) {
            throw new JargonException("transferLength and totalWritten do not agree");
        }
    }

    protected void sendInNetworkOrder(int value) throws IOException {
        byte[] bytes = new byte[4];
        Host.copyInt(value, bytes);
        this.getOut().write(bytes);
        this.getOut().flush();
    }

    protected void sendInLittleEndian(int value) throws IOException {
        byte[] theBytes = new byte[4];
        int reversed = Integer.reverseBytes(value);
        Host.copyInt(reversed, theBytes);
        this.getOut().write(theBytes);
        this.getOut().flush();
    }
}

