/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.InvalidArgumentException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.SpecificQueryException;
import org.irods.jargon.core.packinstr.GeneralAdminInpForSQ;
import org.irods.jargon.core.packinstr.SpecificQueryInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.SpecificQueryAO;
import org.irods.jargon.core.pub.domain.SpecificQueryDefinition;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryResultProcessingUtils;
import org.irods.jargon.core.query.SpecificQuery;
import org.irods.jargon.core.query.SpecificQueryResultSet;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificQueryAOImpl
extends IRODSGenericAO
implements SpecificQueryAO {
    private static final String EXECUTING_SQUERY_PI = "executing specific query PI";
    public static final Logger log = LoggerFactory.getLogger(SpecificQueryAOImpl.class);

    protected SpecificQueryAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws SpecificQueryException, JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public List<SpecificQueryDefinition> listSpecificQueryByAliasLike(String specificQueryAlias) throws DataNotFoundException, JargonException {
        log.info("findSpecificQueryByAliasLike()");
        return this.listSpecificQueryByAliasLike(specificQueryAlias, "");
    }

    @Override
    public List<SpecificQueryDefinition> listSpecificQueryByAliasLike(String specificQueryAlias, String zoneHint) throws DataNotFoundException, JargonException {
        SpecificQueryResultSet resultSet;
        log.info("findSpecificQueryByAliasLike()");
        this.checkSupportForSpecificQuery();
        if (specificQueryAlias == null || specificQueryAlias.isEmpty()) {
            throw new IllegalArgumentException("null specificQueryAlias");
        }
        if (zoneHint == null) {
            throw new IllegalArgumentException("null zoneHint");
        }
        log.info("alias:{}", (Object)specificQueryAlias);
        log.info("zoneHint:{}", (Object)zoneHint);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(specificQueryAlias);
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("listQueryByAliasLike", arguments, 0, zoneHint);
        try {
            resultSet = this.executeSpecificQueryUsingAliasWithoutAliasLookup(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), false);
        }
        catch (JargonQueryException e) {
            log.error("query exception for specific query:{}", (Object)specificQuery, (Object)e);
            throw new JargonException("query exception processing specific query", e);
        }
        ArrayList<SpecificQueryDefinition> specificQueryDefinitions = new ArrayList<SpecificQueryDefinition>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            SpecificQueryDefinition specificQueryDefinition = new SpecificQueryDefinition();
            specificQueryDefinition.setAlias(row.getColumn(0));
            specificQueryDefinition.setSql(row.getColumn(1));
            specificQueryDefinition.setCount(row.getRecordCount());
            specificQueryDefinition.setLastResult(row.isLastResult());
            specificQueryDefinition.setArgumentCount(SpecificQueryAOImpl.countArgumentsInQuery(specificQueryDefinition.getSql()));
            specificQueryDefinition.setColumnNames(SpecificQueryAOImpl.parseColumnNamesFromQuery(specificQueryDefinition.getSql()));
            specificQueryDefinitions.add(specificQueryDefinition);
        }
        log.info("query definitions:{}", specificQueryDefinitions);
        return specificQueryDefinitions;
    }

    @Override
    public SpecificQueryDefinition findSpecificQueryByAlias(String specificQueryAlias) throws DataNotFoundException, JargonException {
        return this.findSpecificQueryByAlias(specificQueryAlias, "");
    }

    @Override
    public SpecificQueryDefinition findSpecificQueryByAlias(String specificQueryAlias, String zoneHint) throws DataNotFoundException, JargonException {
        SpecificQueryResultSet resultSet;
        log.info("findSpecificQueryByAlias()");
        this.checkSupportForSpecificQuery();
        if (specificQueryAlias == null || specificQueryAlias.isEmpty()) {
            throw new IllegalArgumentException("null specificQueryAlias");
        }
        if (zoneHint == null) {
            throw new IllegalArgumentException("null zoneHint");
        }
        log.info("alias:{}", (Object)specificQueryAlias);
        log.info("zoneHint:{}", (Object)zoneHint);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(specificQueryAlias);
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("findQueryByAlias", arguments, 0, zoneHint);
        try {
            resultSet = this.executeSpecificQueryUsingAliasWithoutAliasLookup(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), false);
        }
        catch (JargonQueryException e) {
            log.error("query exception for specific query:{}", (Object)specificQuery, (Object)e);
            throw new JargonException("query exception processing specific query", e);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        SpecificQueryDefinition specificQueryDefinition = new SpecificQueryDefinition();
        specificQueryDefinition.setAlias(row.getColumn(0));
        specificQueryDefinition.setSql(row.getColumn(1));
        specificQueryDefinition.setCount(row.getRecordCount());
        specificQueryDefinition.setLastResult(row.isLastResult());
        specificQueryDefinition.setArgumentCount(SpecificQueryAOImpl.countArgumentsInQuery(specificQueryDefinition.getSql()));
        specificQueryDefinition.setColumnNames(SpecificQueryAOImpl.parseColumnNamesFromQuery(specificQueryDefinition.getSql()));
        log.info("query definition:{}", (Object)specificQueryDefinition);
        return specificQueryDefinition;
    }

    public static List<String> parseColumnNamesFromQuery(String sql) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("null or empty sql");
        }
        String lcSql = sql.toLowerCase();
        int posSelect = lcSql.indexOf("select");
        if (posSelect == -1) {
            throw new IllegalArgumentException("no select statement found");
        }
        int posFrom = lcSql.indexOf("from");
        if (posFrom == -1) {
            throw new IllegalArgumentException("no from statement found");
        }
        String colNames = sql.substring(posSelect + 6, posFrom);
        if ((posSelect = colNames.indexOf("distinct")) > -1) {
            colNames = colNames.substring(posSelect + 8);
        }
        String[] colList = colNames.split(",");
        ArrayList<String> listToReturn = new ArrayList<String>();
        for (String name : colList) {
            int posCloseParen = name.indexOf(")");
            if (posCloseParen > -1) {
                int posOpenParen = colNames.indexOf("(");
                name = posOpenParen > -1 ? name.substring(posOpenParen + 1, posCloseParen) : name.substring(0, posCloseParen);
            }
            listToReturn.add(name.trim());
        }
        return listToReturn;
    }

    public static int countArgumentsInQuery(String sql) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("null or empty sql");
        }
        return MiscIRODSUtils.countCharsInString(sql, '?');
    }

    @Override
    public void addSpecificQuery(SpecificQueryDefinition specificQuery) throws JargonException, DuplicateDataException {
        this.checkSupportForSpecificQuery();
        if (specificQuery == null) {
            throw new IllegalArgumentException("cannot create specific query with null SpecificQueryDefinition object");
        }
        log.info("creating specific query: {}", (Object)specificQuery);
        GeneralAdminInpForSQ queryPI = GeneralAdminInpForSQ.instanceForAddSpecificQuery(specificQuery);
        log.info(EXECUTING_SQUERY_PI);
        try {
            this.getIRODSProtocol().irodsFunction(queryPI);
        }
        catch (InvalidArgumentException e) {
            log.error("invalid argument exception adding a specific query, see if caused by alias not unique");
            if (e.getMessage().indexOf("Alias is not unique") != -1) {
                throw new DuplicateDataException(e.getMessage());
            }
            throw e;
        }
        log.info("added specific query");
    }

    @Override
    public void removeSpecificQuery(SpecificQueryDefinition specificQuery) throws JargonException {
        this.checkSupportForSpecificQuery();
        if (specificQuery == null) {
            throw new IllegalArgumentException("cannot remove specific query with null SpecificQueryDefinition object");
        }
        log.info("removing specific query: {}", (Object)specificQuery);
        GeneralAdminInpForSQ queryPI = GeneralAdminInpForSQ.instanceForRemoveSpecificQuery(specificQuery);
        log.info(EXECUTING_SQUERY_PI);
        this.getIRODSProtocol().irodsFunction(queryPI);
        log.info("removed specific query");
    }

    @Override
    public void removeSpecificQueryByAlias(String alias) throws JargonException, DuplicateDataException {
        this.checkSupportForSpecificQuery();
        if (alias == null) {
            throw new IllegalArgumentException("cannot remove specific query with null alias");
        }
        log.info("removing specific query by alias: {}", (Object)alias);
        GeneralAdminInpForSQ queryPI = GeneralAdminInpForSQ.instanceForRemoveSpecificQueryByAlias(alias);
        log.info(EXECUTING_SQUERY_PI);
        this.getIRODSProtocol().irodsFunction(queryPI);
        log.info("removed specific query");
    }

    @Override
    public void removeAllSpecificQueryBySQL(String sqlQuery) throws JargonException, DuplicateDataException {
        this.checkSupportForSpecificQuery();
        if (sqlQuery == null) {
            throw new IllegalArgumentException("cannot remove specific query with null SQL query");
        }
        log.info("removing all specific queries by sql query: {}", (Object)sqlQuery);
        GeneralAdminInpForSQ queryPI = GeneralAdminInpForSQ.instanceForRemoveAllSpecificQueryBySQL(sqlQuery);
        log.info(EXECUTING_SQUERY_PI);
        this.getIRODSProtocol().irodsFunction(queryPI);
        log.info("removed specific query");
    }

    private SpecificQueryResultSet executeSpecificQueryUsingAliasWithoutAliasLookup(SpecificQuery specificQuery, int maxRows, boolean justTryWithoutSupportCheck) throws DataNotFoundException, JargonException, JargonQueryException {
        log.info("executeSpecificQueryUsingAlias()");
        if (specificQuery == null) {
            throw new IllegalArgumentException("null specific query");
        }
        if (!justTryWithoutSupportCheck) {
            this.checkSupportForSpecificQuery();
        }
        SpecificQueryDefinition specificQueryDefinition = new SpecificQueryDefinition();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("alias");
        columnNames.add("sql");
        specificQueryDefinition.setColumnNames(columnNames);
        return this.queryOnAliasGivenDefinition(specificQuery, maxRows, specificQueryDefinition, 0);
    }

    @Override
    public SpecificQueryResultSet executeSpecificQueryUsingAlias(SpecificQuery specificQuery, int maxRows) throws DataNotFoundException, JargonException, JargonQueryException {
        return this.executeSpecificQueryUsingAlias(specificQuery, maxRows, 0);
    }

    @Override
    public SpecificQueryResultSet executeSpecificQueryUsingAlias(SpecificQuery specificQuery, int maxRows, int userDefinedOffset) throws DataNotFoundException, JargonException, JargonQueryException {
        log.info("executeSpecificQueryUsingAlias()");
        if (specificQuery == null) {
            throw new IllegalArgumentException("null specific query");
        }
        this.checkSupportForSpecificQuery();
        SpecificQueryDefinition specificQueryDefinition = this.findSpecificQueryByAlias(specificQuery.getQueryString());
        log.info("found specific query definition by alias");
        if (specificQuery.getArguments().size() != specificQueryDefinition.getArgumentCount()) {
            log.error("number of parameters in query does not match number of parameters provided");
            throw new JargonQueryException("mismatch between query parameters and number of arguments provided");
        }
        return this.queryOnAliasGivenDefinition(specificQuery, maxRows, specificQueryDefinition, userDefinedOffset);
    }

    private SpecificQueryResultSet queryOnAliasGivenDefinition(SpecificQuery specificQuery, int maxRows, SpecificQueryDefinition specificQueryDefinition, int userDefinedOffset) throws JargonException {
        SpecificQueryInp specificQueryInp = SpecificQueryInp.instance(specificQuery.getArguments(), specificQuery.getQueryString(), maxRows, specificQuery.getContinuationValue(), specificQuery.getZoneHint());
        Tag response = null;
        try {
            response = this.getIRODSProtocol().irodsFunction(specificQueryInp);
        }
        catch (DataNotFoundException e) {
            log.info("no reults from iRODS, return as an empty result set");
            return new SpecificQueryResultSet(specificQuery, specificQueryDefinition.getColumnNames());
        }
        int continuation = QueryResultProcessingUtils.getContinuationValue(response);
        boolean hasMoreRecords = false;
        if (continuation != 0) {
            hasMoreRecords = true;
        }
        List<IRODSQueryResultRow> resultRows = QueryResultProcessingUtils.translateResponseIntoResultSet(response, specificQueryDefinition.getColumnNames(), continuation, userDefinedOffset);
        SpecificQueryResultSet results = new SpecificQueryResultSet(specificQuery, resultRows, specificQueryDefinition.getColumnNames(), hasMoreRecords, continuation);
        log.info("doing a close for this page...");
        this.closeResultSet(results);
        return results;
    }

    @Override
    public SpecificQueryResultSet executeSpecificQueryUsingSql(SpecificQuery specificQuery, int maxRows) throws DataNotFoundException, JargonException, JargonQueryException {
        return this.executeSpecificQueryUsingSql(specificQuery, maxRows, 0);
    }

    @Override
    public SpecificQueryResultSet executeSpecificQueryUsingSql(SpecificQuery specificQuery, int maxRows, int userDefinedOffset) throws DataNotFoundException, JargonException, JargonQueryException {
        log.info("executeSpecificQueryUsingSql()");
        if (specificQuery == null) {
            throw new IllegalArgumentException("null specific query");
        }
        this.checkSupportForSpecificQuery();
        List<String> columnNames = SpecificQueryAOImpl.parseColumnNamesFromQuery(specificQuery.getQueryString());
        int numberOfParameters = SpecificQueryAOImpl.countArgumentsInQuery(specificQuery.getQueryString());
        if (specificQuery.getArguments().size() != numberOfParameters) {
            log.error("number of parameters in query does not match number of parameters provided");
            throw new JargonQueryException("mismatch between query parameters and number of arguments provided");
        }
        SpecificQueryInp specificQueryInp = SpecificQueryInp.instance(specificQuery.getArguments(), specificQuery.getQueryString(), maxRows, specificQuery.getContinuationValue(), specificQuery.getZoneHint());
        Tag response = null;
        response = this.getIRODSProtocol().irodsFunction(specificQueryInp);
        int continuation = QueryResultProcessingUtils.getContinuationValue(response);
        boolean hasMoreRecords = false;
        if (continuation != 0) {
            hasMoreRecords = true;
        }
        List<IRODSQueryResultRow> resultRows = QueryResultProcessingUtils.translateResponseIntoResultSet(response, columnNames, continuation, userDefinedOffset);
        SpecificQueryResultSet results = new SpecificQueryResultSet(specificQuery, resultRows, columnNames, hasMoreRecords, continuation);
        log.info("doing a close for this page...");
        this.closeResultSet(results);
        return results;
    }

    private void closeResultSet(SpecificQueryResultSet specificQueryResultSet) throws JargonException {
        log.info("closeResultSet()");
        if (specificQueryResultSet == null) {
            throw new IllegalArgumentException("null specificQueryResultSet");
        }
        if (specificQueryResultSet.getContinuationIndex() == 0) {
            log.info("continuation is zero, no need to close...silently ignored");
            return;
        }
        SpecificQueryInp specificQueryInp = SpecificQueryInp.instanceForClose(specificQueryResultSet);
        this.getIRODSProtocol().irodsFunction(specificQueryInp);
        log.info("specific query closed");
    }

    @Override
    public boolean isSupportsSpecificQuery() throws JargonException {
        return !this.isSpecificQueryToBeBypassed();
    }

    @Override
    public boolean isSpecificQueryToBeBypassed() throws JargonException {
        if (this.getIRODSServerProperties().isSupportsSpecificQuery()) {
            log.info("by version number I know I support specific query");
            return false;
        }
        return true;
    }

    private void checkSupportForSpecificQuery() throws JargonException {
        if (this.isSpecificQueryToBeBypassed()) {
            throw new JargonException("no support for specific query");
        }
    }
}

