/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.checksum;

import org.irods.jargon.core.checksum.ChecksumManager;
import org.irods.jargon.core.checksum.ChecksumMethodUnavailableException;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;
import org.irods.jargon.core.pub.EnvironmentalInfoAO;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumManagerImpl
implements ChecksumManager {
    private final IRODSAccount irodsAccount;
    private final IRODSAccessObjectFactory irodsAccessObjectFactory;
    public static final Logger log = LoggerFactory.getLogger(ChecksumManagerImpl.class);

    public ChecksumManagerImpl(IRODSAccount irodsAccount, IRODSAccessObjectFactory irodsAccessObjectFactory) {
        this.irodsAccount = irodsAccount;
        this.irodsAccessObjectFactory = irodsAccessObjectFactory;
    }

    @Override
    public ChecksumEncodingEnum determineChecksumEncodingForTargetServer() throws JargonException {
        log.info("determineChecksumEncodingForTargetServer()");
        log.info("checking discovered cache to see if I have stored a checksum type...");
        String checksumTypeRetrievedFromCache = this.irodsAccessObjectFactory.getDiscoveredServerPropertiesCache().retrieveValue(this.irodsAccount.getHost(), this.irodsAccount.getZone(), "checksumType");
        if (checksumTypeRetrievedFromCache != null) {
            log.info("found cached checksum encoding:{}", (Object)checksumTypeRetrievedFromCache);
            return ChecksumEncodingEnum.findTypeByString(checksumTypeRetrievedFromCache);
        }
        ChecksumEncodingEnum encodingFromProperties = this.irodsAccessObjectFactory.getJargonProperties().getChecksumEncoding();
        if (encodingFromProperties == null) {
            throw new JargonRuntimeException("jargon properties has null checksum encoding");
        }
        log.info("encoding from properties:{}", (Object)encodingFromProperties);
        if (encodingFromProperties == ChecksumEncodingEnum.MD5) {
            log.info("jargon properties specifies MD5");
            this.cacheEncoding(ChecksumEncodingEnum.MD5);
            return ChecksumEncodingEnum.MD5;
        }
        if (encodingFromProperties == ChecksumEncodingEnum.SHA256) {
            log.info("jargon properties specifies SHA256");
            this.cacheEncoding(ChecksumEncodingEnum.SHA256);
            return ChecksumEncodingEnum.SHA256;
        }
        EnvironmentalInfoAO environmentalInfoAO = this.irodsAccessObjectFactory.getEnvironmentalInfoAO(this.irodsAccount);
        IRODSServerProperties serverProperties = environmentalInfoAO.getIRODSServerProperties();
        boolean isConsortium = serverProperties.isAtLeastIrods410();
        log.info("is this consortium? (post 3.3.1):{}", (Object)isConsortium);
        if (isConsortium) {
            log.info("is consortium iRODS");
            if (encodingFromProperties == ChecksumEncodingEnum.DEFAULT) {
                log.info("checksumEncoding set to SHA256");
                this.cacheEncoding(ChecksumEncodingEnum.SHA256);
                return ChecksumEncodingEnum.SHA256;
            }
            if (encodingFromProperties == ChecksumEncodingEnum.STRONG) {
                log.info("checksumEncoding set to SHA256");
                this.cacheEncoding(ChecksumEncodingEnum.SHA256);
                return ChecksumEncodingEnum.SHA256;
            }
            log.error("unhandled checksum type:{}", (Object)encodingFromProperties);
            throw new JargonException("unknown checksum type");
        }
        if (serverProperties.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.3.1")) {
            log.info("is at least iRODS3.3.1");
            if (encodingFromProperties == ChecksumEncodingEnum.DEFAULT) {
                log.info("checksumEncoding set to MD5");
                this.cacheEncoding(ChecksumEncodingEnum.MD5);
                return ChecksumEncodingEnum.MD5;
            }
            if (encodingFromProperties == ChecksumEncodingEnum.STRONG) {
                log.info("checksumEncoding set to SHA256");
                this.cacheEncoding(ChecksumEncodingEnum.SHA256);
                return ChecksumEncodingEnum.SHA256;
            }
            log.error("unhandled checksum type:{}", (Object)encodingFromProperties);
            throw new JargonException("unknown checksum type");
        }
        log.info("checksumEncoding set to MD5");
        this.cacheEncoding(ChecksumEncodingEnum.MD5);
        return ChecksumEncodingEnum.MD5;
    }

    private void cacheEncoding(ChecksumEncodingEnum checksumEncoding) {
        this.irodsAccessObjectFactory.getDiscoveredServerPropertiesCache().cacheAProperty(this.irodsAccount.getHost(), this.irodsAccount.getZone(), "checksumType", checksumEncoding.toString());
    }

    @Override
    public ChecksumValue determineChecksumEncodingFromIrodsData(String irodsChecksumValue) throws ChecksumMethodUnavailableException {
        log.info("determineChecksumEncodingFromIrodsData()");
        if (irodsChecksumValue == null || irodsChecksumValue.isEmpty()) {
            return null;
        }
        log.info("irodsChecksumValue:{}", (Object)irodsChecksumValue);
        ChecksumEncodingEnum checksumEncodingEnum = null;
        int idxColon = irodsChecksumValue.indexOf(":");
        if (idxColon == -1) {
            checksumEncodingEnum = ChecksumEncodingEnum.MD5;
        } else {
            String beforeColon = irodsChecksumValue.substring(0, idxColon);
            if (beforeColon.equals("md5")) {
                checksumEncodingEnum = ChecksumEncodingEnum.MD5;
            } else if (beforeColon.equals("sha2")) {
                checksumEncodingEnum = ChecksumEncodingEnum.SHA256;
            } else {
                log.error("unknown checksum type:{}", (Object)beforeColon);
                throw new ChecksumMethodUnavailableException("unknown checksum type:" + beforeColon);
            }
        }
        log.info("have encoding of :{}", (Object)checksumEncodingEnum);
        String checksumData = idxColon == -1 ? irodsChecksumValue : irodsChecksumValue.substring(idxColon + 1);
        ChecksumValue checksumValue = new ChecksumValue();
        checksumValue.setChecksumEncoding(checksumEncodingEnum);
        checksumValue.setChecksumStringValue(checksumData);
        checksumValue.setChecksumTransmissionFormat(irodsChecksumValue);
        log.info("checksumValue from iRODS:{}", (Object)checksumValue);
        return checksumValue;
    }
}

