/*
 * Decompiled with CFR 0.152.
 */
package io.milton.property;

import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.util.List;
import javax.xml.namespace.QName;

public interface PropertySource {
    public Object getProperty(QName var1, Resource var2) throws NotAuthorizedException;

    public void setProperty(QName var1, Object var2, Resource var3) throws PropertySetException, NotAuthorizedException;

    public PropertyMetaData getPropertyMetaData(QName var1, Resource var2) throws NotAuthorizedException, BadRequestException;

    public void clearProperty(QName var1, Resource var2) throws PropertySetException, NotAuthorizedException;

    public List<QName> getAllPropertyNames(Resource var1) throws NotAuthorizedException, BadRequestException;

    public static class PropertySetException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Response.Status status;
        private String notes;

        public PropertySetException(Response.Status status, String notes) {
            this.status = status;
            this.notes = notes;
        }

        public Response.Status getStatus() {
            return this.status;
        }

        public String getErrorNotes() {
            return this.notes;
        }
    }

    public static class PropertyMetaData {
        private final PropertyAccessibility accessibility;
        private final Class valueType;
        public static final PropertyMetaData UNKNOWN = new PropertyMetaData(PropertyAccessibility.UNKNOWN, null);

        public PropertyMetaData(PropertyAccessibility accessibility, Class valueType) {
            this.accessibility = accessibility;
            this.valueType = valueType;
        }

        public PropertyAccessibility getAccessibility() {
            return this.accessibility;
        }

        public Class getValueType() {
            return this.valueType;
        }

        public boolean isUnknown() {
            return this.accessibility.equals((Object)PropertyAccessibility.UNKNOWN);
        }

        public boolean isWritable() {
            return this.accessibility.equals((Object)PropertyAccessibility.WRITABLE);
        }
    }

    public static enum PropertyAccessibility {
        UNKNOWN,
        READ_ONLY,
        WRITABLE;

    }
}

