/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt._AppEventHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._OpenAppHandler;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

class _AppEventLegacyHandler
implements AboutHandler,
PreferencesHandler,
_OpenAppHandler,
AppReOpenedListener,
OpenFilesHandler,
PrintFilesHandler,
QuitHandler {
    final _AppEventHandler parent;
    final Vector<ApplicationListener> legacyAppListeners = new Vector();
    boolean blockLegacyAPI;
    boolean initializedParentDispatchers;

    _AppEventLegacyHandler(_AppEventHandler _AppEventHandler2) {
        this.parent = _AppEventHandler2;
    }

    void blockLegacyAPI() {
        this.blockLegacyAPI = true;
    }

    void checkIfLegacyAPIBlocked() {
        if (!this.blockLegacyAPI) {
            return;
        }
        throw new IllegalStateException("Cannot add com.apple.eawt.ApplicationListener after installing an app event handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLegacyAppListener(ApplicationListener applicationListener) {
        Object object;
        this.checkIfLegacyAPIBlocked();
        if (!this.initializedParentDispatchers) {
            object = Application.getApplication().menuBarHandler;
            boolean bl = ((_AppMenuBarHandler)object).prefsMenuItemExplicitlySet;
            this.parent.aboutDispatcher.setHandler(this);
            this.parent.preferencesDispatcher.setHandler(this);
            if (!bl) {
                ((_AppMenuBarHandler)object).setPreferencesMenuItemVisible(false);
            }
            this.parent.openAppDispatcher.setHandler(this);
            this.parent.reOpenAppDispatcher.addListener(this);
            this.parent.openFilesDispatcher.setHandler(this);
            this.parent.printFilesDispatcher.setHandler(this);
            this.parent.quitDispatcher.setHandler(this);
            this.initializedParentDispatchers = true;
        }
        object = this.legacyAppListeners;
        synchronized (object) {
            this.legacyAppListeners.addElement(applicationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLegacyAppListener(ApplicationListener applicationListener) {
        this.checkIfLegacyAPIBlocked();
        Vector<ApplicationListener> vector = this.legacyAppListeners;
        synchronized (vector) {
            this.legacyAppListeners.removeElement(applicationListener);
        }
    }

    @Override
    public void handleAbout(AppEvent.AboutEvent aboutEvent) {
        final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener applicationListener) {
                applicationListener.handleAbout(applicationEvent);
            }
        });
        if (applicationEvent.isHandled()) {
            return;
        }
        this.parent.openCocoaAboutWindow();
    }

    @Override
    public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
        final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener applicationListener) {
                applicationListener.handlePreferences(applicationEvent);
            }
        });
    }

    @Override
    public void handleOpenApp() {
        final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener applicationListener) {
                applicationListener.handleOpenApplication(applicationEvent);
            }
        });
    }

    @Override
    public void appReOpened(AppEvent.AppReOpenedEvent appReOpenedEvent) {
        final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener applicationListener) {
                applicationListener.handleReOpenApplication(applicationEvent);
            }
        });
    }

    @Override
    public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
        List<File> list = openFilesEvent.getFiles();
        for (File file : list) {
            final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit(), file.getAbsolutePath());
            this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

                @Override
                public void dispatchEvent(ApplicationListener applicationListener) {
                    applicationListener.handleOpenFile(applicationEvent);
                }
            });
        }
    }

    @Override
    public void printFiles(AppEvent.PrintFilesEvent printFilesEvent) {
        List<File> list = printFilesEvent.getFiles();
        for (File file : list) {
            final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit(), file.getAbsolutePath());
            this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

                @Override
                public void dispatchEvent(ApplicationListener applicationListener) {
                    applicationListener.handlePrintFile(applicationEvent);
                }
            });
        }
    }

    @Override
    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
        final ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(applicationEvent, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener applicationListener) {
                applicationListener.handleQuit(applicationEvent);
            }
        });
        if (applicationEvent.isHandled()) {
            this.parent.performQuit();
        } else {
            this.parent.cancelQuit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEventToEachListenerUntilHandled(ApplicationEvent applicationEvent, EventDispatcher eventDispatcher) {
        Vector<ApplicationListener> vector = this.legacyAppListeners;
        synchronized (vector) {
            if (this.legacyAppListeners.size() == 0) {
                return;
            }
            Enumeration<ApplicationListener> enumeration = this.legacyAppListeners.elements();
            while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                eventDispatcher.dispatchEvent(enumeration.nextElement());
            }
        }
    }

    static interface EventDispatcher {
        public void dispatchEvent(ApplicationListener var1);
    }
}

