/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveThumbnailSetIterator
implements Iterator<OneDriveThumbnailSet.Metadata> {
    private static final URLTemplate GET_THUMBNAILS_URL = new URLTemplate("/drive/items/%s/thumbnails");
    private static final URLTemplate GET_THUMBNAILS_ROOT_URL = new URLTemplate("/drive/items/%s/thumbnails");
    private final OneDriveAPI api;
    private final String itemId;
    private final JsonObjectIterator jsonObjectIterator;

    OneDriveThumbnailSetIterator(OneDriveAPI api) {
        this.api = Objects.requireNonNull(api);
        this.itemId = null;
        this.jsonObjectIterator = new JsonObjectIterator(api, GET_THUMBNAILS_ROOT_URL.build(api.getBaseURL()));
    }

    public OneDriveThumbnailSetIterator(OneDriveAPI api, String itemId) {
        this.api = Objects.requireNonNull(api);
        this.itemId = Objects.requireNonNull(itemId);
        this.jsonObjectIterator = new JsonObjectIterator(api, GET_THUMBNAILS_URL.build(api.getBaseURL(), itemId));
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public OneDriveThumbnailSet.Metadata next() throws OneDriveRuntimeException {
        JsonObject nextObject = this.jsonObjectIterator.next();
        int id = Integer.parseInt(nextObject.get("id").asString());
        OneDriveThumbnailSet thumbnail = this.itemId == null ? new OneDriveThumbnailSet(this.api, id) : new OneDriveThumbnailSet(this.api, this.itemId, id);
        OneDriveThumbnailSet oneDriveThumbnailSet = thumbnail;
        oneDriveThumbnailSet.getClass();
        return new OneDriveThumbnailSet.Metadata(oneDriveThumbnailSet, nextObject);
    }
}

