/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveCopyOperation;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveLongRunningAction;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;
import org.nuxeo.onedrive.client.OneDrivePermission;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.OneDriveThumbnail;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.OneDriveThumbnailSetIterator;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.facets.FileSystemInfoFacet;

public abstract class OneDriveItem
extends OneDriveResource {
    private final OneDriveResource parent;
    private final ItemIdentifierType itemIdentifierType;

    OneDriveItem(OneDriveAPI api) {
        super(api);
        this.parent = null;
        this.itemIdentifierType = null;
    }

    public OneDriveItem(OneDriveAPI api, OneDriveResource parent) {
        super(api);
        this.parent = Objects.requireNonNull(parent);
        this.itemIdentifierType = null;
    }

    public OneDriveItem(OneDriveAPI api, OneDriveResource parent, String resourceIdentifier, ItemIdentifierType itemIdentifierType) {
        super(api, resourceIdentifier);
        this.parent = Objects.requireNonNull(parent);
        this.itemIdentifierType = itemIdentifierType;
    }

    public OneDriveDrive getDrive() {
        if (this.parent instanceof OneDriveDrive) {
            return (OneDriveDrive)this.parent;
        }
        if (this.parent instanceof OneDriveItem) {
            return ((OneDriveItem)this.parent).getDrive();
        }
        return null;
    }

    public ItemIdentifierType getItemIdentifierType() {
        return this.itemIdentifierType;
    }

    public void delete() throws IOException {
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL());
        ((OneDriveResponse)new OneDriveRequest(url, "DELETE").sendRequest(this.getApi().getExecutor())).close();
    }

    public void patch(OneDrivePatchOperation patchOperation) throws IOException {
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL());
        new OneDriveJsonRequest(url, "PATCH", patchOperation.build()).sendRequest(this.getApi().getExecutor()).close();
    }

    public OneDriveLongRunningAction copy(OneDriveCopyOperation copyOperation) throws IOException {
        URL url = this.getCopyURL().build(this.getApi().getBaseURL());
        OneDriveJsonResponse jsonResponse = new OneDriveJsonRequest(url, "POST", copyOperation.build()).sendRequest(this.getApi().getExecutor());
        URL locationUrl = new URL(jsonResponse.getLocation());
        return new OneDriveLongRunningAction(locationUrl, this.getApi());
    }

    public URLTemplate getMetadataURL() {
        return new URLTemplate(this.getFullyQualifiedPath());
    }

    public URLTemplate getCopyURL() {
        return new URLTemplate(this.getActionPath("copy"));
    }

    public URLTemplate getSharedLinkUrl() {
        String action = this.getApi().isGraphConnection() ? "createLink" : "oneDrive.createLink";
        return new URLTemplate(this.getActionPath(action));
    }

    @Override
    public String getFullyQualifiedPath() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parent.getFullyQualifiedPath());
        String identifier = this.getItemIdentifier();
        if (identifier != null) {
            ItemIdentifierType itemIdentifierType = this.getItemIdentifierType();
            if (itemIdentifierType == ItemIdentifierType.Id) {
                builder.append("/items");
            } else if (itemIdentifierType == ItemIdentifierType.Path) {
                if (this.parent instanceof OneDriveDrive) {
                    builder.append("/root");
                }
                builder.append(':');
            }
            builder.append(String.format("/%s", this.getItemIdentifier()));
        } else {
            builder.append("/root");
        }
        return builder.toString();
    }

    protected String getActionPath(String action) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFullyQualifiedPath());
        if (this.getItemIdentifierType() == ItemIdentifierType.Path) {
            builder.append(':');
        }
        builder.append(String.format("/%s", action));
        return builder.toString();
    }

    public abstract Metadata getMetadata(OneDriveExpand ... var1) throws IOException;

    public OneDriveThumbnailSet.Metadata getThumbnailSet() throws OneDriveAPIException {
        try {
            Iterator<OneDriveThumbnailSet.Metadata> iterator = this.getThumbnailSets().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveAPIException(e);
        }
        return null;
    }

    public OneDriveThumbnail.Metadata getThumbnail(OneDriveThumbnailSize size) throws IOException {
        return new OneDriveThumbnail(this.getApi(), this.getItemIdentifier(), size).getMetadata();
    }

    public InputStream downloadThumbnail(OneDriveThumbnailSize size) throws IOException {
        return new OneDriveThumbnail(this.getApi(), this.getItemIdentifier(), size).download();
    }

    Iterable<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
        return () -> new OneDriveThumbnailSetIterator(this.getApi(), this.getItemIdentifier());
    }

    public OneDrivePermission.Metadata createSharedLink(OneDriveSharingLink.Type type) throws IOException {
        URL url = this.getSharedLinkUrl().build(this.getApi().getBaseURL(), this.getItemIdentifier());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST", new JsonObject().add("type", type.getType()));
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        JsonObject json = response.getContent();
        String permissionId = json.asObject().get("id").asString();
        OneDrivePermission permission = this.isRoot() ? new OneDrivePermission(this.getApi(), permissionId) : new OneDrivePermission(this.getApi(), this.getItemIdentifier(), permissionId);
        OneDrivePermission oneDrivePermission = permission;
        oneDrivePermission.getClass();
        return oneDrivePermission.new OneDrivePermission.Metadata(json);
    }

    public static Metadata parseJson(OneDriveAPI api, JsonObject nextObject) {
        if (nextObject.get("folder") != null && !nextObject.get("folder").isNull()) {
            return OneDriveFolder.parseJson(api, nextObject);
        }
        if (nextObject.get("file") != null && !nextObject.get("file").isNull()) {
            return OneDriveFile.parseJson(api, nextObject);
        }
        if (nextObject.get("package") != null && !nextObject.get("package").isNull()) {
            return OneDrivePackageItem.parseJson(api, nextObject);
        }
        if (nextObject.get("remoteItem") != null && !nextObject.get("remoteItem").isNull()) {
            return OneDriveRemoteItem.parseJson(api, nextObject);
        }
        throw new OneDriveRuntimeException(new OneDriveAPIException("The object type is currently not handled"));
    }

    public abstract class Metadata
    extends OneDriveResource.Metadata {
        private String name;
        private String eTag;
        private OneDriveIdentitySet createdBy;
        private ZonedDateTime createdDateTime;
        private OneDriveIdentitySet lastModifiedBy;
        private ZonedDateTime lastModifiedDateTime;
        private long size;
        private OneDriveFolder.Reference parentReference;
        private String webUrl;
        private String description;
        private boolean deleted;
        private FileSystemInfoFacet fileSystemInfo;
        private List<OneDriveThumbnailSet.Metadata> thumbnailSets;

        public Metadata(JsonObject json) {
            super(json);
            this.thumbnailSets = Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public String getETag() {
            return this.eTag;
        }

        public OneDriveIdentitySet getCreatedBy() {
            return this.createdBy;
        }

        public ZonedDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        public OneDriveIdentitySet getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public ZonedDateTime getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public long getSize() {
            return this.size;
        }

        public OneDriveFolder.Reference getParentReference() {
            return this.parentReference;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public FileSystemInfoFacet getFileSystemInfo() {
            return this.fileSystemInfo;
        }

        public OneDriveThumbnailSet.Metadata getThumbnailSet() {
            return this.thumbnailSets.stream().findFirst().orElse(null);
        }

        List<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
            return Collections.unmodifiableList(this.thumbnailSets);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("name".equals(memberName)) {
                    this.name = value.asString();
                } else if ("eTag".equals(memberName)) {
                    this.eTag = value.asString();
                } else if ("createdBy".equals(memberName)) {
                    this.createdBy = new OneDriveIdentitySet(value.asObject());
                } else if ("createdDateTime".equals(memberName)) {
                    this.createdDateTime = ZonedDateTime.parse(value.asString());
                } else if ("lastModifiedBy".equals(memberName)) {
                    this.lastModifiedBy = new OneDriveIdentitySet(value.asObject());
                } else if ("lastModifiedDateTime".equals(memberName)) {
                    this.lastModifiedDateTime = ZonedDateTime.parse(value.asString());
                } else if ("size".equals(memberName)) {
                    this.size = value.asLong();
                } else if ("parentReference".equals(memberName)) {
                    JsonObject valueObject = value.asObject();
                    OneDriveDrive drive = new OneDriveDrive(OneDriveItem.this.getApi(), valueObject.get("driveId").asString());
                    if (valueObject.names().contains("id")) {
                        OneDriveFolder parentFolder;
                        String id = valueObject.get("id").asString();
                        OneDriveFolder oneDriveFolder = parentFolder = new OneDriveFolder(OneDriveItem.this.getApi(), drive, id, ItemIdentifierType.Id);
                        oneDriveFolder.getClass();
                        this.parentReference = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                    } else {
                        OneDriveFolder oneDriveFolder = drive.getRoot();
                        oneDriveFolder.getClass();
                        this.parentReference = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                    }
                } else if ("fileSystemInfo".equals(memberName)) {
                    this.fileSystemInfo = new FileSystemInfoFacet();
                    this.fileSystemInfo.fromJson(value.asObject());
                } else if ("webUrl".equals(memberName)) {
                    this.webUrl = value.asString();
                } else if ("description".equals(memberName)) {
                    this.description = value.asString();
                } else if ("deleted".equals(memberName)) {
                    this.deleted = true;
                } else if ("thumbnailSets".equals(memberName)) {
                    this.parseThumbnailsMember(value.asArray());
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private void parseThumbnailsMember(JsonArray thumbnails) {
            this.thumbnailSets = new ArrayList<OneDriveThumbnailSet.Metadata>(thumbnails.size());
            for (JsonValue value : thumbnails) {
                OneDriveThumbnailSet thumbnailSet;
                JsonObject thumbnail = value.asObject();
                int id = Integer.parseInt(thumbnail.get("id").asString());
                OneDriveThumbnailSet oneDriveThumbnailSet = thumbnailSet = new OneDriveThumbnailSet(OneDriveItem.this.getApi(), this.getId(), id);
                oneDriveThumbnailSet.getClass();
                this.thumbnailSets.add(new OneDriveThumbnailSet.Metadata(oneDriveThumbnailSet, thumbnail));
            }
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        @Override
        public OneDriveItem getResource() {
            return OneDriveItem.this;
        }

        public OneDriveFolder.Metadata asFolder() {
            throw new UnsupportedOperationException("Not a folder.");
        }

        public OneDriveFile.Metadata asFile() {
            throw new UnsupportedOperationException("Not a file.");
        }
    }

    public static enum ItemIdentifierType {
        Id,
        Path;

    }
}

