/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryDownloadFeature
implements Download {
    private final Session<?> session;
    private final Download proxy;
    private final VaultRegistry registry;

    public VaultRegistryDownloadFeature(Session<?> session, Download proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void download(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback connectionCallback, PasswordCallback passwordCallback) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Download.class, this.proxy).download(file, local, throttle, listener, status, connectionCallback, passwordCallback);
    }

    @Override
    public boolean offset(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Download.class, this.proxy).offset(file);
    }

    @Override
    public Download withReader(Read reader) {
        this.proxy.withReader(reader);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryDownloadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

