/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.log4j.Logger;

public abstract class DelayedHttpEntity
extends AbstractHttpEntity {
    private static final Logger log = Logger.getLogger(DelayedHttpEntity.class);
    private final CountDownLatch entry;
    private final CountDownLatch exit = new CountDownLatch(1);
    private OutputStream stream;
    private boolean consumed = false;

    public DelayedHttpEntity() {
        this(new CountDownLatch(1));
    }

    public DelayedHttpEntity(CountDownLatch entry) {
        this.entry = entry;
    }

    public boolean isRepeatable() {
        return true;
    }

    public abstract long getContentLength();

    public InputStream getContent() throws IOException {
        throw new IOException(new UnsupportedOperationException("No content here"));
    }

    public OutputStream getStream() {
        if (null == this.stream) {
            return NullOutputStream.NULL_OUTPUT_STREAM;
        }
        return this.stream;
    }

    public void writeTo(final OutputStream out) throws IOException {
        try {
            this.stream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    out.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    out.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    out.write(b);
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        DelayedHttpEntity.this.exit.countDown();
                    }
                }
            };
        }
        finally {
            this.entry.countDown();
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.exit);
        this.consumed = true;
    }

    public boolean isStreaming() {
        return !this.consumed;
    }

    public CountDownLatch getEntry() {
        return this.entry;
    }
}

