/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.exception.ConfigurationException;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MantaSSLConnectionSocketFactory.class);
    private final Set<String> supportedProtocols;
    private final Set<String> supportedCipherSuites;

    public MantaSSLConnectionSocketFactory(ConfigContext config) {
        super(MantaSSLConnectionSocketFactory.buildContext(), MantaUtils.csv2array(config.getHttpsProtocols()), MantaUtils.csv2array(config.getHttpsCipherSuites()), MantaSSLConnectionSocketFactory.getDefaultHostnameVerifier());
        this.supportedProtocols = config.getHttpsProtocols() != null ? new LinkedHashSet<String>(MantaUtils.fromCsv(config.getHttpsProtocols())) : Collections.emptySet();
        this.supportedCipherSuites = config.getHttpsCipherSuites() != null ? new LinkedHashSet<String>(MantaUtils.fromCsv(config.getHttpsCipherSuites())) : Collections.emptySet();
    }

    private static SSLContext buildContext() {
        return SSLContexts.createDefault();
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
        LinkedHashSet<String> enabledProtocols = new LinkedHashSet<String>(Arrays.asList(socket.getEnabledProtocols()));
        LinkedHashSet<String> enabledCipherSuites = new LinkedHashSet<String>(Arrays.asList(socket.getEnabledCipherSuites()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled TLS protocols: {}", (Object)MantaUtils.asString(enabledProtocols));
            LOG.debug("Enabled cipher suites: {}", (Object)MantaUtils.asString(enabledCipherSuites));
        }
        this.supportedCipherSuites.retainAll(enabledCipherSuites);
        if (!this.supportedCipherSuites.isEmpty()) {
            try {
                String[] supportedCiphers = new String[this.supportedCipherSuites.size()];
                this.supportedCipherSuites.toArray(supportedCiphers);
                socket.setEnabledCipherSuites(supportedCiphers);
            }
            catch (IllegalArgumentException e) {
                String msg = String.format("Unsupported encryption provider. Supported providers: %s", MantaUtils.asString(socket.getEnabledCipherSuites()));
                throw new ConfigurationException(msg, e);
            }
        }
        this.supportedProtocols.retainAll(enabledProtocols);
        if (!this.supportedProtocols.isEmpty()) {
            String[] supportedProtos = new String[this.supportedProtocols.size()];
            this.supportedProtocols.toArray(supportedProtos);
            socket.setEnabledProtocols(supportedProtos);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supported TLS protocols: {}", (Object)MantaUtils.asString(this.supportedProtocols));
            LOG.debug("Supported cipher suites: {}", (Object)MantaUtils.asString(this.supportedCipherSuites));
        }
    }
}

