/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;

public class WriteVersioningWorker
extends Worker<Boolean> {
    private final List<Path> files;
    private final LoginCallback prompt;
    private final VersioningConfiguration configuration;

    public WriteVersioningWorker(List<Path> files, LoginCallback prompt, VersioningConfiguration configuration) {
        this.files = files;
        this.prompt = prompt;
        this.configuration = configuration;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Versioning feature = session.getFeature(Versioning.class);
        for (Path file : this.getContainers(this.files)) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(feature, file);
        }
        return true;
    }

    private void write(Versioning feature, Path file) throws BackgroundException {
        feature.setConfiguration(file, this.prompt, this.configuration);
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteVersioningWorker that = (WriteVersioningWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteVersioningWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

