/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListEncryptionKeysWorker
extends Worker<Set<Encryption.Algorithm>> {
    private final List<Path> files;
    private final LoginCallback prompt;

    public ListEncryptionKeysWorker(List<Path> files, LoginCallback prompt) {
        this.files = files;
        this.prompt = prompt;
    }

    @Override
    public Set<Encryption.Algorithm> run(Session<?> session) throws BackgroundException {
        Encryption feature = session.getFeature(Encryption.class);
        HashSet<Encryption.Algorithm> keys = new HashSet<Encryption.Algorithm>();
        for (Path file : this.getContainers(this.files)) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            keys.addAll(feature.getKeys(file, this.prompt));
        }
        return keys;
    }

    @Override
    public Set<Encryption.Algorithm> initialize() {
        return Collections.emptySet();
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListEncryptionKeysWorker that = (ListEncryptionKeysWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadEncryptionKeysWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

