/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.date.InvalidDateException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class ISO8601DateParser {
    private boolean check(StringTokenizer st, String token) throws InvalidDateException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new InvalidDateException(String.format("Missing [%s]", token));
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Calendar getCalendar(String isodate) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!this.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!this.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!this.check(st, "T") || !st.hasMoreTokens()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!this.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new InvalidDateException("No seconds specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("Z")) return calendar;
            if (!tok.equals("+") && !tok.equals("-")) {
                throw new InvalidDateException("only Z, + or - allowed");
            }
            boolean plus = tok.equals("+");
            if (!st.hasMoreTokens()) {
                throw new InvalidDateException("Missing hour field");
            }
            int tzhour = Integer.parseInt(st.nextToken());
            int tzmin = 0;
            if (!this.check(st, ":") || !st.hasMoreTokens()) {
                throw new InvalidDateException("Missing minute field");
            }
            tzmin = Integer.parseInt(st.nextToken());
            if (plus) {
                ((Calendar)calendar).add(10, -tzhour);
                ((Calendar)calendar).add(12, -tzmin);
                return calendar;
            } else {
                ((Calendar)calendar).add(10, tzhour);
                ((Calendar)calendar).add(12, tzmin);
            }
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException(String.format("[%s] is not an integer", ex.getMessage()), ex);
        }
    }

    public Date parse(String input) throws InvalidDateException {
        if (StringUtils.isBlank((CharSequence)input)) {
            throw new InvalidDateException();
        }
        return this.getCalendar(input).getTime();
    }
}

