/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Referenceable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.log4j.Logger;

public abstract class AbstractCache<T extends Referenceable>
implements Cache<T> {
    private static final Logger log = Logger.getLogger(AbstractCache.class);
    private final Map<T, AttributedList<T>> impl;

    public AbstractCache(int size) {
        this.impl = size == Integer.MAX_VALUE ? Collections.synchronizedMap(new LinkedHashMap()) : (size == 0 ? Collections.emptyMap() : Collections.synchronizedMap(new LRUMap(size)));
    }

    @Override
    public T lookup(CacheReference<T> reference) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Set<T> keySet() {
        return this.impl.keySet();
    }

    public boolean containsKey(T reference) {
        return this.impl.containsKey(reference);
    }

    @Override
    public AttributedList<T> remove(T reference) {
        AttributedList<T> removed = this.impl.remove(reference);
        if (null == removed) {
            return AttributedList.emptyList();
        }
        return removed;
    }

    @Override
    public AttributedList<T> get(T reference) {
        AttributedList<T> children = this.impl.get(reference);
        if (null == children) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No cache for %s", reference));
            }
            return AttributedList.emptyList();
        }
        return children;
    }

    @Override
    public AttributedList<T> put(T reference, AttributedList<T> children) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Caching %s", reference));
        }
        return this.impl.put(reference, children);
    }

    @Override
    public boolean isCached(T reference) {
        return this.containsKey(reference);
    }

    @Override
    public boolean isValid(T reference) {
        if (this.isCached(reference)) {
            return !this.get(reference).attributes().isInvalid();
        }
        return false;
    }

    @Override
    public void invalidate(T reference) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Invalidate %s", reference));
        }
        if (this.containsKey(reference)) {
            this.get(reference).attributes().setInvalid(true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No cache for %s", reference));
        }
    }

    @Override
    public void clear() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Clear cache %s", this));
        }
        this.impl.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cache{");
        sb.append("size=").append(this.impl.size());
        sb.append('}');
        return sb.toString();
    }
}

