/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalDeleteFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class LocalMoveFeature
implements Move {
    private final LocalSession session;
    private Delete delete;

    public LocalMoveFeature(LocalSession session) {
        this.session = session;
        this.delete = new LocalDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            Files.move(this.session.toPath(file), this.session.toPath(renamed), StandardCopyOption.REPLACE_EXISTING);
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new LocalAttributesFinderFeature(this.session).find(renamed));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

