/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.azure.AzureAttributesFinderFeature;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.azure.AzureWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.OperationContext;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;

public class AzureTouchFeature
implements Touch<Void> {
    private final AzureSession session;
    private final OperationContext context;
    private Write<Void> writer;

    public AzureTouchFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
        this.writer = new AzureWriteFeature(session, context);
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum(file).compute((InputStream)new NullInputStream(0L), status));
        }
        new DefaultStreamCloser().close((OutputStream)this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback()));
        return new Path(file.getParent(), file.getName(), file.getType(), new AzureAttributesFinderFeature(this.session, this.context).find(file));
    }

    public AzureTouchFeature withWriter(Write<Void> writer) {
        this.writer = writer;
        return this;
    }
}

