/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.transfer.FileRestartDataSegment;
import org.irods.jargon.core.transfer.FileRestartInfoIdentifier;

public class FileRestartInfo {
    private String irodsAccountIdentifier = "";
    private String localAbsolutePath = "";
    private String irodsAbsolutePath = "";
    private RestartStatus restartStatus = RestartStatus.OFF;
    private RestartType restartType = RestartType.PUT;
    private int numberRestarts = 0;
    private List<FileRestartDataSegment> fileRestartDataSegments = new ArrayList<FileRestartDataSegment>();

    public String getLocalAbsolutePath() {
        return this.localAbsolutePath;
    }

    public void setLocalAbsolutePath(String localAbsolutePath) {
        this.localAbsolutePath = localAbsolutePath;
    }

    public String getIrodsAbsolutePath() {
        return this.irodsAbsolutePath;
    }

    public void setIrodsAbsolutePath(String irodsAbsolutePath) {
        this.irodsAbsolutePath = irodsAbsolutePath;
    }

    public RestartStatus getRestartStatus() {
        return this.restartStatus;
    }

    public void setRestartStatus(RestartStatus restartStatus) {
        this.restartStatus = restartStatus;
    }

    public List<FileRestartDataSegment> getFileRestartDataSegments() {
        return this.fileRestartDataSegments;
    }

    public void setFileRestartDataSegments(List<FileRestartDataSegment> fileRestartDataSegments) {
        this.fileRestartDataSegments = fileRestartDataSegments;
    }

    public FileRestartInfoIdentifier identifierFromThisInfo() {
        FileRestartInfoIdentifier identifier = new FileRestartInfoIdentifier();
        identifier.setAbsolutePath(this.irodsAbsolutePath);
        identifier.setIrodsAccountIdentifier(this.irodsAccountIdentifier);
        identifier.setRestartType(this.restartType);
        return identifier;
    }

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("FileRestartInfo [");
        if (this.irodsAccountIdentifier != null) {
            builder.append("irodsAccountIdentifier=");
            builder.append(this.irodsAccountIdentifier);
            builder.append(", ");
        }
        if (this.localAbsolutePath != null) {
            builder.append("localAbsolutePath=");
            builder.append(this.localAbsolutePath);
            builder.append(", ");
        }
        if (this.irodsAbsolutePath != null) {
            builder.append("irodsAbsolutePath=");
            builder.append(this.irodsAbsolutePath);
            builder.append(", ");
        }
        if (this.restartStatus != null) {
            builder.append("restartStatus=");
            builder.append((Object)this.restartStatus);
            builder.append(", ");
        }
        if (this.restartType != null) {
            builder.append("restartType=");
            builder.append((Object)this.restartType);
            builder.append(", ");
        }
        builder.append(", numberRestarts=");
        builder.append(this.numberRestarts);
        builder.append(", ");
        if (this.fileRestartDataSegments != null) {
            builder.append("fileRestartDataSegments=");
            builder.append(this.fileRestartDataSegments.subList(0, Math.min(this.fileRestartDataSegments.size(), 10)));
        }
        builder.append("]");
        return builder.toString();
    }

    public String getIrodsAccountIdentifier() {
        return this.irodsAccountIdentifier;
    }

    public void setIrodsAccountIdentifier(String irodsAccountIdentifier) {
        this.irodsAccountIdentifier = irodsAccountIdentifier;
    }

    public RestartType getRestartType() {
        return this.restartType;
    }

    public void setRestartType(RestartType restartType) {
        this.restartType = restartType;
    }

    public int getNumberRestarts() {
        return this.numberRestarts;
    }

    public void setNumberRestarts(int numberRestarts) {
        this.numberRestarts = numberRestarts;
    }

    public long estimateLengthSoFar() {
        long total = 0L;
        for (FileRestartDataSegment fileRestartDataSegment : this.fileRestartDataSegments) {
            total += fileRestartDataSegment.getLength();
        }
        return total;
    }

    public static enum RestartType {
        PUT,
        GET;

    }

    public static enum RestartStatus {
        ON,
        OFF;

    }
}

