/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.AbstractIRODSQueryResultSet;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;

public class IRODSQueryResultSet
extends AbstractIRODSQueryResultSet {
    final TranslatedIRODSGenQuery translatedIRODSQuery;

    public static IRODSQueryResultSet instance(TranslatedIRODSGenQuery translatedIRODSQuery, List<IRODSQueryResultRow> results, int continuationIndex, int totalRecords) throws JargonException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (GenQuerySelectField selectField : translatedIRODSQuery.getSelectFields()) {
            columnNames.add(selectField.getSelectFieldColumnName());
        }
        return new IRODSQueryResultSet(translatedIRODSQuery, results, columnNames, continuationIndex, totalRecords);
    }

    private IRODSQueryResultSet(TranslatedIRODSGenQuery translatedIRODSQuery, List<IRODSQueryResultRow> results, List<String> columnNames, int continuationIndex, int totalRecords) throws JargonException {
        super(results, Collections.unmodifiableList(columnNames), continuationIndex > 0, continuationIndex, totalRecords);
        if (translatedIRODSQuery == null) {
            throw new JargonException("translated IRODS query is null");
        }
        this.translatedIRODSQuery = translatedIRODSQuery;
    }

    public TranslatedIRODSGenQuery getTranslatedIRODSQuery() {
        return this.translatedIRODSQuery;
    }

    public String toString() {
        int maxLen = 100;
        StringBuilder builder = new StringBuilder();
        builder.append("IRODSQueryResultSet [");
        if (this.translatedIRODSQuery != null) {
            builder.append("translatedIRODSQuery=").append(this.translatedIRODSQuery).append(", ");
        }
        if (this.results != null) {
            builder.append("results=").append(this.results.subList(0, Math.min(this.results.size(), 100))).append(", ");
        }
        builder.append("hasMoreRecords=").append(this.hasMoreRecords).append(", ");
        if (this.columnNames != null) {
            builder.append("columnNames=").append(this.columnNames.subList(0, Math.min(this.columnNames.size(), 100))).append(", ");
        }
        builder.append("continuationIndex=").append(this.continuationIndex).append(", totalRecords=").append(this.totalRecords).append("]");
        return builder.toString();
    }
}

