/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.rule;

import java.lang.reflect.Array;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.utils.Base64;

public class IRODSRuleParameter {
    static final String INT_PI = "INT_PI";
    static final String MY_INT = "myInt";
    static final String STR_PI = "STR_PI";
    static final String MY_STR = "myStr";
    static final String BUF_LEN_PI = "BUF_LEN_PI";
    static final String BIN_BYTES_BUF_PI = "BinBytesBuf_PI";
    static final String EXEC_CMD_OUT_PI = "ExecCmdOut_PI";
    static final String BUFLEN = "buflen";
    static final String BUF = "buf";
    static final String NULL_PI = "NULL_PI";
    private String uniqueName = "";
    private Object value;
    private String type;

    public IRODSRuleParameter() {
        this(null, null, STR_PI);
    }

    public IRODSRuleParameter(String name, int value) {
        this(name, value, INT_PI);
    }

    public IRODSRuleParameter(String value) {
        this(null, value, STR_PI);
    }

    public IRODSRuleParameter(byte[] value) {
        this(null, value, BUF_LEN_PI);
    }

    public IRODSRuleParameter(String name, String value) {
        this(name, value, STR_PI);
    }

    public IRODSRuleParameter(String name, Object value, String type) {
        if (value == null) {
            this.setNullValue();
        } else {
            this.value = value;
            this.type = type;
        }
        if (name != null) {
            this.uniqueName = name;
        } else {
            for (int i = 0; i < 8; ++i) {
                this.uniqueName = this.uniqueName + (char)(65.0 + Math.random() * 25.0);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IRODSRuleParameter");
        sb.append("\n   uniqueName:");
        sb.append(this.getUniqueName());
        sb.append("\n   type:");
        sb.append(this.getType());
        sb.append("\n   value:");
        sb.append(this.getStringValue());
        return sb.toString();
    }

    void setNullValue() {
        this.value = "";
        this.type = NULL_PI;
    }

    void setIntValue(int value) {
        this.value = value;
        this.type = INT_PI;
    }

    void setStringValue(String value) {
        this.value = value;
        this.type = STR_PI;
    }

    void setByteValue(byte[] value) {
        this.value = value;
        this.type = BUF_LEN_PI;
    }

    public String getType() {
        return this.type;
    }

    public int getIntValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return Integer.parseInt(this.value.toString());
    }

    public String getStringValue() {
        if (this.value.getClass().isArray() && this.type.equals(EXEC_CMD_OUT_PI)) {
            StringBuilder stringValue = new StringBuilder();
            int alength = Array.getLength(this.value);
            for (int ij = 0; ij < alength; ++ij) {
                String msg;
                if (Array.get(this.value, ij) == null || (msg = Array.get(this.value, ij).toString()) == null || (msg = String.valueOf(Base64.fromString(msg))) == null) continue;
                stringValue.append(msg);
            }
            return stringValue.toString();
        }
        return this.value.toString();
    }

    public byte[] getByteValue() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return this.value.toString().getBytes();
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsStringWithQuotesStripped() {
        int initQuote = this.getStringValue().indexOf(34);
        int finalQuote = this.getStringValue().lastIndexOf(34);
        if (initQuote > -1 && finalQuote > -1) {
            return this.getStringValue().substring(initQuote + 1, finalQuote);
        }
        return this.getStringValue();
    }

    public Tag createMsParamArray() {
        Tag param = new Tag("MsParam_PI", new Tag[]{new Tag("label", this.getUniqueName()), new Tag("type", this.getType())});
        if (this.type.equals(INT_PI)) {
            param.addTag(new Tag(INT_PI, new Tag[]{new Tag(MY_INT, this.getIntValue())}));
        } else if (this.type.equals(BUF_LEN_PI)) {
            param.addTag(new Tag(BUF_LEN_PI, new Tag[]{new Tag(BUFLEN, this.getByteValue().length), new Tag(BUF, new String(this.getByteValue()))}));
        } else {
            param.addTag(new Tag(STR_PI, new Tag[]{new Tag(MY_STR, this.getStringValue())}));
        }
        return param;
    }
}

