/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.OutputStream;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.OpenedDataObjInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileIOOperationsAOImpl
extends IRODSGenericAO
implements FileIOOperations {
    static Logger log = LoggerFactory.getLogger(FileIOOperationsAOImpl.class);

    protected FileIOOperationsAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public int write(int fd, byte[] buffer, int offset, int length) throws JargonException {
        if (fd <= 0) {
            throw new IllegalArgumentException("file is not open, file descriptor was less than zero:" + fd);
        }
        if (buffer == null || buffer.length == 0) {
            throw new IllegalArgumentException("null or empty buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset less than zero");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("zero or negative length");
        }
        if (offset > length) {
            throw new IllegalArgumentException("offset of:" + offset + " is > length:" + length);
        }
        if (offset > buffer.length) {
            throw new IllegalArgumentException("offset of:" + offset + " is greater than the buffer length of:" + buffer.length);
        }
        if (log.isDebugEnabled()) {
            log.debug("attempting to write to fd:" + fd + " a buffer with a size of " + buffer.length + " using a length of " + length + " and an offset of " + offset);
        }
        OpenedDataObjInp openedDataObjInp = OpenedDataObjInp.instanceForFileWrite(fd, offset, length);
        Tag message = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", openedDataObjInp.getParsedTags(), null, 0, 0, buffer, offset, length, openedDataObjInp.getApiNumber());
        return message.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
    }

    @Override
    public int fileRead(int fd, OutputStream destination, long length) throws JargonException {
        log.debug("file read for fd: {}", (Object)fd);
        if (fd <= 0) {
            throw new IllegalArgumentException("invalid file descriptor");
        }
        OpenedDataObjInp fileReadInp = OpenedDataObjInp.instanceForFileRead(fd, length);
        AbstractIRODSMidLevelProtocol irodsProtocol = this.getIRODSProtocol();
        Tag message = irodsProtocol.irodsFunction(fileReadInp);
        if (message == null) {
            return -1;
        }
        length = message.getTag("MsgHeader_PI").getTag("bsLen").getIntValue();
        irodsProtocol.read(destination, length);
        return message.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
    }

    @Override
    public int fileRead(int fd, byte[] buffer, int offset, int length) throws JargonException {
        log.debug("file read for fd: {}", (Object)fd);
        if (fd <= 0) {
            throw new IllegalArgumentException("invalid file descriptor");
        }
        OpenedDataObjInp fileReadInp = OpenedDataObjInp.instanceForFileRead(fd, length);
        AbstractIRODSMidLevelProtocol irodsProtocol = this.getIRODSProtocol();
        Tag message = irodsProtocol.irodsFunction(fileReadInp);
        if (message == null) {
            return -1;
        }
        length = message.getTag("MsgHeader_PI").getTag("bsLen").getIntValue();
        int read = irodsProtocol.read(buffer, offset, length);
        if (read == message.getTag("MsgHeader_PI").getTag("intInfo").getIntValue()) {
            return read;
        }
        log.error("did not read length equal to response length, expected" + length + " bytes actually read:" + read);
        throw new JargonException("Bytes read mismatch");
    }

    @Override
    public long seek(int fd, long seek, FileIOOperations.SeekWhenceType whence) throws JargonException {
        if (whence != FileIOOperations.SeekWhenceType.SEEK_START && whence != FileIOOperations.SeekWhenceType.SEEK_CURRENT && whence != FileIOOperations.SeekWhenceType.SEEK_END) {
            log.error("Illegal Argument exception, whence value in seek must be SEEK_START, SEEK_CURRENT, or SEEK_END");
            throw new IllegalArgumentException("whence value in seek must be SEEK_START, SEEK_CURRENT, or SEEK_END");
        }
        if (fd <= 0) {
            log.error("no valid file handle provided");
            throw new IllegalArgumentException("no valid file handle provided");
        }
        OpenedDataObjInp openedDataObjInp = OpenedDataObjInp.instanceForFileSeek(seek, fd, whence.ordinal());
        Tag message = this.getIRODSProtocol().irodsFunction(openedDataObjInp);
        return message.getTag("offset").getLongValue();
    }

    @Override
    public ChecksumValue computeChecksumOnIrodsFile(String irodsFileAbsolutePath) throws JargonException {
        log.info("computeChecksumOnIrodsFile()");
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        log.info("irodsFileAbsolutePath:{}", (Object)irodsFileAbsolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsFileAbsolutePath);
        DataObjectChecksumUtilitiesAO dataObjectChecksumUtilitiesAO = this.getIRODSAccessObjectFactory().getDataObjectChecksumUtilitiesAO(this.getIRODSAccount());
        return dataObjectChecksumUtilitiesAO.computeChecksumOnDataObject(irodsFile);
    }
}

