/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.ResourceGroupAO;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupAOImpl
extends IRODSGenericAO
implements ResourceGroupAO {
    private static Logger log = LoggerFactory.getLogger(ResourceGroupAOImpl.class);

    protected ResourceGroupAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public List<String> listResourceGroupNames() throws JargonException {
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (this.getIRODSServerProperties().isAtLeastIrods410()) {
            log.info("resource groups are not supported post iRODS4, simply list parent resources");
            ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
            return resourceAO.listResourceNames();
        }
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_RESC_GROUP_NAME).addOrderByGenQueryField(RodsGenQueryEnum.COL_RESC_GROUP_NAME, GenQueryOrderByField.OrderByType.ASC);
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
        }
        catch (JargonQueryException e) {
            log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            resourceNames.add(row.getColumn(0));
        }
        return resourceNames;
    }
}

