/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;
import org.nuxeo.onedrive.client.facets.Facet;
import org.nuxeo.onedrive.client.facets.FileSystemInfoFacet;

public class OneDriveTimestampFeature
extends DefaultTimestampFeature {
    private final OneDriveSession session;

    public OneDriveTimestampFeature(OneDriveSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        OneDrivePatchOperation patchOperation = new OneDrivePatchOperation();
        FileSystemInfoFacet info = new FileSystemInfoFacet();
        info.setLastModifiedDateTime(Instant.ofEpochMilli(modified).atOffset(ZoneOffset.UTC));
        patchOperation.facet("fileSystemInfo", (Facet)info);
        OneDriveItem item = this.session.toItem(file);
        try {
            item.patch(patchOperation);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, file);
        }
    }
}

