/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import java.util.Collections;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class TerminalOptionsBuilder {
    private TerminalOptionsBuilder() {
    }

    public static Options options() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"Username");
        OptionBuilder.withLongOpt((String)Params.username.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"username or access key");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.withDescription((String)"Password");
        OptionBuilder.withLongOpt((String)Params.password.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"password or secret key");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withDescription((String)"Selects a file from which the identity (private key) for public key authentication is read");
        OptionBuilder.withLongOpt((String)Params.identity.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"private key file");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withDescription((String)"Download file or folder. Denote a folder with a trailing '/'");
        OptionBuilder.withLongOpt((String)TerminalAction.download.name());
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"url> <[file]");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withDescription((String)"Upload file or folder recursively");
        OptionBuilder.withLongOpt((String)TerminalAction.upload.name());
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"url> <file");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Set explicit permission from octal mode value for uploaded file");
        OptionBuilder.withLongOpt((String)Params.chmod.name());
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"<mode>");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Copy between servers");
        OptionBuilder.withLongOpt((String)TerminalAction.copy.name());
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"url> <url");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Synchronize folders");
        OptionBuilder.withLongOpt((String)TerminalAction.synchronize.name());
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"url> <directory");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Edit file in external editor");
        OptionBuilder.withLongOpt((String)TerminalAction.edit.name());
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"External editor application");
        OptionBuilder.withLongOpt((String)Params.application.name());
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"List files in remote folder");
        OptionBuilder.withLongOpt((String)TerminalAction.list.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withDescription((String)"Delete");
        OptionBuilder.withLongOpt((String)TerminalAction.delete.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"D"));
        OptionBuilder.withDescription((String)"Make directory");
        OptionBuilder.withLongOpt((String)TerminalAction.mkdir.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withDescription((String)"Long list format with modification date and permission mask");
        OptionBuilder.withLongOpt((String)Params.longlist.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'L'));
        OptionBuilder.withDescription((String)"Location of bucket or container");
        OptionBuilder.withLongOpt((String)Params.region.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"location");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Preserve permissions and modification date for transferred files");
        OptionBuilder.withLongOpt((String)Params.preserve.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withDescription((String)"Retry failed connection attempts");
        OptionBuilder.withLongOpt((String)Params.retry.name());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"count");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withDescription((String)"Use UDT protocol if applicable");
        OptionBuilder.withLongOpt((String)Params.udt.name());
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Number of concurrent connections to use for transfers");
        OptionBuilder.withLongOpt((String)Params.parallel.name());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"connections");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Throttle bandwidth");
        OptionBuilder.withLongOpt((String)Params.throttle.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"bytes per second");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Do not save passwords in keychain");
        OptionBuilder.withLongOpt((String)Params.nokeychain.name());
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create());
        StringBuilder b = new StringBuilder().append("\n");
        b.append("Options for downloads and uploads:").append("\n");
        for (TransferAction a : TransferAction.forTransfer(Transfer.Type.download)) {
            b.append("\t").append(a.getTitle()).append("\t").append(a.getDescription()).append(String.format(" (%s)", a.name())).append("\n");
        }
        for (TransferAction a : Collections.singletonList(TransferAction.cancel)) {
            b.append("\t").append(a.getTitle()).append("\t").append(a.getDescription()).append(String.format(" (%s)", a.name())).append("\n");
        }
        b.append("Options for synchronize:").append("\n");
        for (TransferAction a : TransferAction.forTransfer(Transfer.Type.sync)) {
            b.append("\t").append(a.getTitle()).append("\t").append(a.getDescription()).append(String.format(" (%s)", a.name())).append("\n");
        }
        for (TransferAction a : Collections.singletonList(TransferAction.cancel)) {
            b.append("\t").append(a.getTitle()).append("\t").append(a.getDescription()).append(String.format(" (%s)", a.name())).append("\n");
        }
        OptionBuilder.withDescription((String)String.format("Transfer action for existing files%s", b.toString()));
        OptionBuilder.withLongOpt((String)Params.existing.name());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"action");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withDescription((String)"Print transcript");
        OptionBuilder.withLongOpt((String)Params.verbose.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withDescription((String)"Suppress progress messages");
        OptionBuilder.withLongOpt((String)Params.quiet.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withDescription((String)"Assume yes for all prompts");
        OptionBuilder.withLongOpt((String)Params.assumeyes.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'y'));
        OptionBuilder.withDescription((String)"Show version number and quit");
        OptionBuilder.withLongOpt((String)TerminalAction.version.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'V'));
        OptionBuilder.withDescription((String)"Print this help");
        OptionBuilder.withLongOpt((String)TerminalAction.help.name());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"h"));
        return options;
    }

    public static enum Params {
        region,
        longlist,
        preserve,
        retry,
        udt,
        parallel,
        throttle,
        nokeychain,
        existing,
        verbose,
        quiet,
        assumeyes,
        username,
        password,
        identity,
        application,
        chmod;

    }
}

