/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.schmizz.concurrent.ErrorDeliveryUtil;
import net.schmizz.concurrent.Promise;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.ForwardedChannelOpener;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;

public class ConnectionImpl
extends AbstractService
implements Connection {
    private final Object internalSynchronizer = new Object();
    private final AtomicInteger nextID = new AtomicInteger();
    private final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    private final Map<String, ForwardedChannelOpener> openers = new ConcurrentHashMap<String, ForwardedChannelOpener>();
    private final Queue<Promise<SSHPacket, ConnectionException>> globalReqPromises = new ConcurrentLinkedQueue<Promise<SSHPacket, ConnectionException>>();
    private final KeepAlive keepAlive;
    private long windowSize = 0x200000L;
    private int maxPacketSize = 32768;
    private volatile int timeoutMs;

    public ConnectionImpl(Transport trans, KeepAliveProvider keepAlive) {
        super("ssh-connection", trans);
        this.timeoutMs = trans.getTimeoutMs();
        this.keepAlive = keepAlive.provide(this);
    }

    @Override
    public void attach(Channel chan) {
        this.log.debug("Attaching `{}` channel (#{})", (Object)chan.getType(), (Object)chan.getID());
        this.channels.put(chan.getID(), chan);
    }

    @Override
    public Channel get(int id) {
        return this.channels.get(id);
    }

    @Override
    public ForwardedChannelOpener get(String chanType) {
        return this.openers.get(chanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Channel chan) {
        this.log.debug("Forgetting `{}` channel (#{})", (Object)chan.getType(), (Object)chan.getID());
        this.channels.remove(chan.getID());
        Object object = this.internalSynchronizer;
        synchronized (object) {
            if (this.channels.isEmpty()) {
                this.internalSynchronizer.notifyAll();
            }
        }
    }

    @Override
    public void forget(ForwardedChannelOpener opener) {
        this.log.debug("Forgetting opener for `{}` channels: {}", (Object)opener.getChannelType(), (Object)opener);
        this.openers.remove(opener.getChannelType());
    }

    @Override
    public void attach(ForwardedChannelOpener opener) {
        this.log.debug("Attaching opener for `{}` channels: {}", (Object)opener.getChannelType(), (Object)opener);
        this.openers.put(opener.getChannelType(), opener);
    }

    private Channel getChannel(SSHPacket buffer) throws ConnectionException {
        try {
            int recipient = buffer.readUInt32AsInt();
            Channel channel = this.get(recipient);
            if (channel != null) {
                return channel;
            }
            buffer.rpos(buffer.rpos() - 5);
            throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Received " + (Object)((Object)buffer.readMessageID()) + " on unknown channel #" + recipient);
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        if (msg.in(91, 100)) {
            this.getChannel(buf).handle(msg, buf);
        } else if (msg.in(80, 90)) {
            switch (msg) {
                case REQUEST_SUCCESS: {
                    this.gotGlobalReqResponse(buf);
                    break;
                }
                case REQUEST_FAILURE: {
                    this.gotGlobalReqResponse(null);
                    break;
                }
                case CHANNEL_OPEN: {
                    this.gotChannelOpen(buf);
                    break;
                }
                default: {
                    super.handle(msg, buf);
                    break;
                }
            }
        } else {
            super.handle(msg, buf);
        }
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @Override
    public Transport getTransport() {
        return this.trans;
    }

    @Override
    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    @Override
    public long getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this.internalSynchronizer;
        synchronized (object) {
            while (!this.channels.isEmpty()) {
                this.internalSynchronizer.wait();
            }
        }
    }

    @Override
    public int nextID() {
        return this.nextID.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<SSHPacket, ConnectionException> sendGlobalRequest(String name, boolean wantReply, byte[] specifics) throws TransportException {
        Queue<Promise<SSHPacket, ConnectionException>> queue = this.globalReqPromises;
        synchronized (queue) {
            this.log.debug("Making global request for `{}`", (Object)name);
            this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.GLOBAL_REQUEST).putString(name)).putBoolean(wantReply)).putRawBytes(specifics));
            Promise promise = null;
            if (wantReply) {
                promise = new Promise("global req for " + name, ConnectionException.chainer, this.trans.getConfig().getLoggerFactory());
                this.globalReqPromises.add(promise);
            }
            return promise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotGlobalReqResponse(SSHPacket response) throws ConnectionException {
        Queue<Promise<SSHPacket, ConnectionException>> queue = this.globalReqPromises;
        synchronized (queue) {
            Promise<SSHPacket, ConnectionException> gr = this.globalReqPromises.poll();
            if (gr == null) {
                throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Got a global request response when none was requested");
            }
            if (response == null) {
                gr.deliverError(new ConnectionException("Global request [" + gr + "] failed"));
            } else {
                gr.deliver(new SSHPacket(response));
            }
        }
    }

    private void gotChannelOpen(SSHPacket buf) throws ConnectionException, TransportException {
        try {
            String type = buf.readString();
            this.log.debug("Received CHANNEL_OPEN for `{}` channel", (Object)type);
            if (this.openers.containsKey(type)) {
                this.openers.get(type).handleOpen(buf);
            } else {
                this.log.warn("No opener found for `{}` CHANNEL_OPEN request -- rejecting", (Object)type);
                this.sendOpenFailure(buf.readUInt32AsInt(), OpenFailException.Reason.UNKNOWN_CHANNEL_TYPE, "");
            }
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
    }

    @Override
    public void sendOpenFailure(int recipient, OpenFailException.Reason reason, String message) throws TransportException {
        this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.CHANNEL_OPEN_FAILURE).putUInt32(recipient)).putUInt32(reason.getCode())).putString(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyError(SSHException error) {
        super.notifyError(error);
        Queue<Promise<SSHPacket, ConnectionException>> queue = this.globalReqPromises;
        synchronized (queue) {
            ErrorDeliveryUtil.alertPromises((Throwable)error, this.globalReqPromises);
            this.globalReqPromises.clear();
        }
        this.keepAlive.interrupt();
        ErrorNotifiable.Util.alertAll(error, this.channels.values());
        this.channels.clear();
    }

    @Override
    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public KeepAlive getKeepAlive() {
        return this.keepAlive;
    }
}

