/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import org.apache.log4j.Logger;

public class SFTPWriteFeature
extends AppendWriteFeature<Void> {
    private static final Logger log = Logger.getLogger(SFTPWriteFeature.class);
    private final SFTPSession session;
    private final Preferences preferences = PreferencesFactory.get();

    public SFTPWriteFeature(SFTPSession session) {
        super((Session)session);
        this.session = session;
    }

    public StatusOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            EnumSet<OpenMode> flags;
            if (status.isAppend()) {
                flags = status.isExists() ? EnumSet.of(OpenMode.WRITE) : EnumSet.of(OpenMode.CREAT, OpenMode.WRITE);
            } else if (status.isExists()) {
                if (file.isSymbolicLink()) {
                    this.session.sftp().remove(file.getAbsolute());
                    flags = EnumSet.of(OpenMode.CREAT, OpenMode.TRUNC, OpenMode.WRITE);
                } else {
                    flags = EnumSet.of(OpenMode.TRUNC, OpenMode.WRITE);
                }
            } else {
                flags = EnumSet.of(OpenMode.CREAT, OpenMode.TRUNC, OpenMode.WRITE);
            }
            final RemoteFile handle = this.session.sftp().open(file.getAbsolute(), flags);
            int maxUnconfirmedWrites = this.getMaxUnconfirmedWrites(status);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Using %d unconfirmed writes", maxUnconfirmedWrites));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skipping %d bytes", status.getOffset()));
            }
            RemoteFile remoteFile = handle;
            remoteFile.getClass();
            return new VoidStatusOutputStream((OutputStream)new RemoteFile.RemoteFileOutputStream(remoteFile, status.getOffset(), maxUnconfirmedWrites){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    remoteFile2.getClass();
                    super(remoteFile2, x1, x2);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        handle.close();
                        this.close.set(true);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    protected int getMaxUnconfirmedWrites(TransferStatus status) {
        if (-1L == status.getLength()) {
            return this.preferences.getInteger("sftp.write.maxunconfirmed");
        }
        return Integer.min((int)(status.getLength() / (long)this.preferences.getInteger("connection.chunksize")) + 1, this.preferences.getInteger("sftp.write.maxunconfirmed"));
    }

    public boolean temporary() {
        return true;
    }

    public boolean random() {
        return true;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }
}

