/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.io.StreamGobbler;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPCommandFeature
implements Command {
    private static final Logger log = Logger.getLogger(SFTPCommandFeature.class);
    private final SFTPSession session;

    public SFTPCommandFeature(SFTPSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String command, ProgressListener listener, TranscriptListener transcript) throws BackgroundException {
        Session sess;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Send command %s", command));
        }
        try {
            sess = ((SSHClient)this.session.getClient()).startSession();
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
        try {
            listener.message(command);
            Session.Command exec = sess.exec(command);
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader((InputStream)new StreamGobbler(exec.getInputStream()), Charset.forName(this.session.getHost().getEncoding())));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader((InputStream)new StreamGobbler(exec.getErrorStream()), Charset.forName(this.session.getHost().getEncoding())));
            try {
                String line;
                String line2;
                while (null != (line2 = stdoutReader.readLine())) {
                    transcript.log(TranscriptListener.Type.response, line2);
                }
                StringBuilder error = new StringBuilder();
                while (null != (line = stderrReader.readLine())) {
                    transcript.log(TranscriptListener.Type.response, line);
                    if (StringUtils.isNotBlank((CharSequence)error.toString())) {
                        error.append(" ");
                    }
                    error.append(line).append(".");
                }
                if (StringUtils.isNotBlank((CharSequence)error.toString())) {
                    throw new InteroperabilityException(error.toString());
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Command %s returned no errors", command));
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)stdoutReader);
                IOUtils.closeQuietly((Reader)stderrReader);
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

