/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.threading.AbstractRetryCallable;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.TransferBackgroundActionState;
import ch.cyberduck.core.transfer.TransferStatus;

public class DefaultRetryCallable<T>
extends AbstractRetryCallable<T> {
    private final BackgroundExceptionCallable<T> delegate;
    private final ProgressListener listener;
    private final BackgroundActionState cancel;

    public DefaultRetryCallable(BackgroundExceptionCallable<T> delegate, TransferStatus status) {
        this(delegate, new TransferBackgroundActionState(status));
    }

    public DefaultRetryCallable(BackgroundExceptionCallable<T> delegate, BackgroundActionState cancel) {
        this(delegate, new DisabledProgressListener(), cancel);
    }

    public DefaultRetryCallable(BackgroundExceptionCallable<T> delegate, ProgressListener listener, BackgroundActionState cancel) {
        this.delegate = delegate;
        this.listener = listener;
        this.cancel = cancel;
    }

    @Override
    public T call() throws BackgroundException {
        while (!this.cancel.isCanceled()) {
            try {
                return this.delegate.call();
            }
            catch (BackgroundException e) {
                if (this.retry(e, this.listener, this.cancel)) continue;
                throw e;
            }
        }
        throw new ConnectionCanceledException();
    }
}

