/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.serializer.AclDictionary;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.serializer.PermissionDictionary;
import java.util.Collections;

public class PathAttributesDictionary {
    private final DeserializerFactory deserializer;

    public PathAttributesDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public PathAttributesDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> PathAttributes deserialize(T serialized) {
        Object aclObj;
        Object permissionObj;
        String revisionObj;
        String modifiedObj;
        Deserializer dict = this.deserializer.create(serialized);
        PathAttributes attributes = new PathAttributes();
        String sizeObj = dict.stringForKey("Size");
        if (sizeObj != null) {
            attributes.setSize(Long.parseLong(sizeObj));
        }
        if ((modifiedObj = dict.stringForKey("Modified")) != null) {
            attributes.setModificationDate(Long.parseLong(modifiedObj));
        }
        if ((revisionObj = dict.stringForKey("Revision")) != null) {
            attributes.setRevision(Long.parseLong(revisionObj));
        }
        if ((permissionObj = dict.objectForKey("Permission")) != null) {
            attributes.setPermission(new PermissionDictionary().deserialize(permissionObj));
        }
        if ((aclObj = dict.objectForKey("Acl")) != null) {
            attributes.setAcl(new AclDictionary().deserialize(aclObj));
        }
        attributes.setChecksum(Checksum.parse(dict.stringForKey("Checksum")));
        attributes.setVersionId(dict.stringForKey("Version"));
        String duplicateObj = dict.stringForKey("Duplicate");
        if (duplicateObj != null) {
            attributes.setDuplicate(Boolean.valueOf(duplicateObj));
        }
        attributes.setMetadata(Collections.emptyMap());
        attributes.setRegion(dict.stringForKey("Region"));
        attributes.setStorageClass(dict.stringForKey("Storage Class"));
        Object vaultObj = dict.objectForKey("Vault");
        if (vaultObj != null) {
            attributes.setVault(new PathDictionary().deserialize(vaultObj));
        }
        return attributes;
    }
}

